/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.data.writer;

import java.io.IOException;
import java.io.Writer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.meta.data.CategoriesDirective;
import org.apache.avalon.meta.data.CategoryDirective;
import org.apache.avalon.meta.data.ConstructorDirective;
import org.apache.avalon.meta.data.ContextDirective;
import org.apache.avalon.meta.data.DeploymentProfile;
import org.apache.avalon.meta.data.EntryDirective;
import org.apache.avalon.meta.data.ImportDirective;
import org.apache.avalon.meta.data.Parameter;
import org.apache.excalibur.configuration.ConfigurationUtil;

public class XMLDeploymentProfileWriter {
    public static final String INDENT = "  ";

    protected void writeDeploymentProfile(Writer writer, DeploymentProfile profile, String pad) throws Exception {
        writer.write(pad + "<component name=\"" + profile.getName() + "\"");
        writer.write("\n" + pad + "  class=\"" + profile.getClassname() + "\"");
        writer.write("\n" + pad + "  activation=\"" + profile.getActivationPolicy() + "\"");
        if (profile.getCategories() == null && profile.getContext() == null && profile.getConfiguration() == null && profile.getParameters() == null) {
            writer.write("/>");
        } else {
            writer.write(">");
            String padding = pad + INDENT;
            this.writeDeploymentBody(writer, profile, padding);
            writer.write("\n" + pad + "</component>");
        }
    }

    protected void writeDeploymentBody(Writer writer, DeploymentProfile profile, String pad) throws Exception {
        this.writeCategories(writer, profile.getCategories(), pad);
        this.writeContext(writer, profile.getContext(), pad);
        this.writeConfiguration(writer, profile.getConfiguration(), pad);
        this.writeParameters(writer, profile.getParameters(), pad);
    }

    private void writeCategories(Writer writer, CategoriesDirective categories, String pad) throws IOException {
        if (categories == null) {
            return;
        }
        writer.write("\n" + pad + "<categories");
        if (categories.getPriority() != null) {
            writer.write(" priority=\"" + categories.getPriority() + "\"");
        }
        if (categories.getTarget() != null) {
            writer.write(" target=\"" + categories.getTarget() + "\"");
        }
        if (categories.getCategories().length > 0) {
            writer.write(">");
            CategoryDirective[] cats = categories.getCategories();
            String padding = pad + INDENT;
            int i = 0;
            while (i < cats.length) {
                this.writeCategoryDirective(writer, cats[i], padding);
                ++i;
            }
            writer.write("\n" + pad + "</categories>");
        } else {
            writer.write("/>");
        }
    }

    private void writeCategoryDirective(Writer writer, CategoryDirective category, String pad) throws IOException {
        writer.write("\n" + pad + "<category name=\"" + category.getName() + "\"");
        if (category.getPriority() != null) {
            writer.write(" priority=\"" + category.getPriority() + "\"");
        }
        if (category.getTarget() != null) {
            writer.write(" target=\"" + category.getTarget() + "\"");
        }
        writer.write("/>");
    }

    private void writeConfiguration(Writer writer, Configuration config, String pad) throws IOException {
        if (config != null) {
            StringBuffer buffer = new StringBuffer();
            ConfigurationUtil.list((StringBuffer)buffer, (String)pad, (Configuration)config);
            writer.write("\n" + buffer.toString());
        }
    }

    private void writeContext(Writer writer, ContextDirective context, String pad) throws IOException {
        EntryDirective[] entries;
        if (context == null) {
            return;
        }
        writer.write("\n" + pad + "<context");
        if (context.getClassname() != null) {
            writer.write(" class=\"" + context.getClassname() + "\"");
        }
        if ((entries = context.getEntryDirectives()).length == 0) {
            writer.write("/>");
            return;
        }
        writer.write(">");
        String padding = pad + INDENT;
        String fill = padding + INDENT;
        int i = 0;
        while (i < entries.length) {
            EntryDirective entry = entries[i];
            this.writeEntryDirective(writer, entry, fill);
            ++i;
        }
        writer.write("\n" + pad + "</context>");
    }

    private void writeEntryDirective(Writer writer, EntryDirective entry, String pad) throws IOException {
        String padding = pad + INDENT;
        writer.write("\n" + pad + "<entry");
        writer.write(" key=\"" + entry.getKey() + "\">");
        if (entry instanceof ImportDirective) {
            ImportDirective imp = (ImportDirective)entry;
            writer.write("\n" + padding + "<import");
            writer.write(" key=\"" + imp.getKey() + "\"");
            writer.write("/>");
        } else if (entry instanceof ConstructorDirective) {
            String fill = padding + INDENT;
            ConstructorDirective cd = (ConstructorDirective)entry;
            writer.write("\n" + padding + "<constructor");
            if (!cd.getClassname().equals("java.lang.String")) {
                writer.write(" class=\"" + cd.getClassname() + "\"");
            }
            writer.write(">");
            if (cd.getParameters().length > 0) {
                this.writeParams(writer, cd.getParameters(), fill);
                writer.write("\n" + padding + "</constructor>");
            } else {
                writer.write(cd.getArgument());
                writer.write("</constructor>");
            }
        }
        writer.write("\n" + pad + "</entry>");
    }

    private void writeParams(Writer writer, Parameter[] params, String pad) throws IOException {
        int i = 0;
        while (i < params.length) {
            this.writeParam(writer, params[i], pad);
            ++i;
        }
    }

    private void writeParam(Writer writer, Parameter param, String pad) throws IOException {
        writer.write("\n" + pad + "<param");
        if (param.getClassname() != null) {
            writer.write(" class=\"" + param.getClassname() + "\"");
        }
        writer.write(">");
        Parameter[] parameters = param.getParameters();
        if (parameters.length > 0) {
            String padding = pad + INDENT;
            this.writeParams(writer, parameters, padding);
            writer.write("\n" + pad + "</param>");
        } else {
            writer.write(param.getArgument() + "</param>");
        }
    }

    private void writeParameters(Writer writer, Parameters params, String pad) throws IOException, ParameterException {
        if (params == null) {
            return;
        }
        String[] names = params.getNames();
        String padding = pad + INDENT;
        writer.write("\n" + pad + "<parameters>");
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = params.getParameter(name);
            writer.write("\n" + padding + "<parameter");
            writer.write(" name=\"" + name + "\"");
            writer.write(" value=\"" + value + "\"/>");
            ++i;
        }
        writer.write("\n" + pad + "</parameters>");
    }
}

