/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.model.builder;

import java.io.InputStream;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.ModelRuntimeException;
import org.apache.avalon.meta.model.Profile;
import org.apache.avalon.meta.model.builder.ProfileCreator;
import org.apache.avalon.meta.model.builder.XMLProfileCreator;

public final class ProfileBuilder {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$model$builder$ProfileBuilder == null ? (class$org$apache$avalon$meta$model$builder$ProfileBuilder = ProfileBuilder.class$("org.apache.avalon.meta.model.builder.ProfileBuilder")) : class$org$apache$avalon$meta$model$builder$ProfileBuilder));
    private ProfileCreator m_xmlProfileCreator;
    static /* synthetic */ Class class$org$apache$avalon$meta$model$builder$ProfileBuilder;
    static /* synthetic */ Class class$org$apache$avalon$meta$model$Profile;

    public ProfileBuilder() {
        this(class$org$apache$avalon$meta$model$Profile == null ? (class$org$apache$avalon$meta$model$Profile = ProfileBuilder.class$("org.apache.avalon.meta.model.Profile")) : class$org$apache$avalon$meta$model$Profile);
    }

    public ProfileBuilder(Class base) {
        this.m_xmlProfileCreator = ProfileBuilder.createXMLProfileCreator(base);
    }

    public Profile[] build(ClassLoader loader, Type type) throws Exception {
        String xprofile = type.getInfo().getClassname().replace('.', '/') + ".xprofile";
        InputStream inputStream = loader.getResourceAsStream(xprofile);
        ProfileCreator creator = this.getXMLProfileCreator(xprofile);
        return creator.createPackagedProfiles(loader, type, inputStream);
    }

    public Profile build(Type type, Configuration config) throws Exception {
        return this.m_xmlProfileCreator.createProfile(type, config);
    }

    private ProfileCreator getXMLProfileCreator(String classname) throws Exception {
        if (null != this.m_xmlProfileCreator) {
            return this.m_xmlProfileCreator;
        }
        String message = REZ.getString("builder.missing-xml-creator.error", (Object)classname);
        throw new Exception(message);
    }

    private static ProfileCreator createXMLProfileCreator(Class base) {
        XMLProfileCreator xmlProfileCreator = null;
        try {
            xmlProfileCreator = new XMLProfileCreator(base);
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to create the XML Profile Creator. Base: " + base.getName();
            throw new ModelRuntimeException(error, e);
        }
        return xmlProfileCreator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

