/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.model.builder;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.meta.ConfigurationBuilder;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.Category;
import org.apache.avalon.meta.model.ContextDirective;
import org.apache.avalon.meta.model.Entry;
import org.apache.avalon.meta.model.Import;
import org.apache.avalon.meta.model.LoggingDirective;
import org.apache.avalon.meta.model.Mode;
import org.apache.avalon.meta.model.ModelRuntimeException;
import org.apache.avalon.meta.model.Parameter;
import org.apache.avalon.meta.model.Profile;
import org.apache.avalon.meta.model.builder.ProfileCreator;
import org.apache.excalibur.configuration.CascadingConfiguration;
import org.xml.sax.InputSource;

public class XMLProfileCreator
implements ProfileCreator {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$info$builder$XMLTypeCreator == null ? (class$org$apache$avalon$meta$info$builder$XMLTypeCreator = XMLProfileCreator.class$("org.apache.avalon.meta.info.builder.XMLTypeCreator")) : class$org$apache$avalon$meta$info$builder$XMLTypeCreator));
    private Class m_clazz;
    private Constructor m_base;
    static /* synthetic */ Class class$org$apache$avalon$meta$info$builder$XMLTypeCreator;
    static /* synthetic */ Class class$org$apache$avalon$meta$model$Profile;

    public XMLProfileCreator() {
        this(class$org$apache$avalon$meta$model$Profile == null ? (class$org$apache$avalon$meta$model$Profile = XMLProfileCreator.class$("org.apache.avalon.meta.model.Profile")) : class$org$apache$avalon$meta$model$Profile);
    }

    public XMLProfileCreator(Class base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        this.m_clazz = base;
    }

    protected Class getBaseClass() {
        return this.m_clazz;
    }

    public Profile[] createPackagedProfiles(ClassLoader loader, Type type, InputStream inputStream) throws Exception {
        if (inputStream != null) {
            InputSource input = new InputSource(inputStream);
            Configuration configuration = ConfigurationBuilder.build(input);
            return this.createPackagedProfiles(loader, type, configuration);
        }
        Profile profile = this.createImplicitProfile(type);
        return new Profile[]{profile};
    }

    public Profile createProfile(Type type, Configuration config) throws Exception {
        return this.createProfile(type, config, null);
    }

    public Profile createProfile(Type type, Configuration config, Configuration defaults) throws Exception {
        return this.createProfile(type, config, defaults, null);
    }

    public Profile createProfile(Type type, Configuration config, Configuration defaults, LoggingDirective logging) throws Exception {
        return this.buildProfile(type, config, defaults, logging, Mode.EXPLICIT);
    }

    private Profile[] createPackagedProfiles(ClassLoader loader, Type type, Configuration info) throws Exception {
        Vector<Profile> vector = new Vector<Profile>();
        Configuration[] profiles = info.getChildren("profile");
        if (profiles.length == 0) {
            Profile profile = this.createImplicitProfile(type);
            return new Profile[]{profile};
        }
        int i = 0;
        while (i < profiles.length) {
            vector.add(this.buildProfile(type, profiles[i], Mode.PACKAGED));
            ++i;
        }
        return (Profile[])vector.toArray((Object[])Array.newInstance(this.m_clazz, 0));
    }

    private Profile buildProfile(Type type, Configuration profile, Mode mode) throws Exception {
        return this.buildProfile(type, profile, null, null, mode);
    }

    private Profile buildProfile(Type type, Configuration config, Configuration custom, LoggingDirective logging, Mode mode) throws Exception {
        String name = config.getAttribute("name");
        LoggingDirective categories = this.createLoggingDirective(name, config.getChild("categories"), logging);
        Parameters params = Parameters.fromConfiguration((Configuration)config.getChild("parameters"));
        ContextDirective contextDirective = this.createContextDirective(config.getChild("context"));
        Object configuration = type.getConfiguration();
        if (configuration != null) {
            if (config.getChild("configuration", false) != null) {
                configuration = new CascadingConfiguration(config.getChild("configuration"), configuration);
            }
        } else {
            configuration = config.getChild("configuration", false);
        }
        if (custom != null) {
            configuration = configuration != null ? new CascadingConfiguration(custom, configuration) : custom;
        }
        if (configuration == null) {
            configuration = new DefaultConfiguration("configuration", "XMLProfileCreator.class");
        }
        boolean activation = this.getActivationPolicy(config);
        try {
            Profile profile = (Profile)this.m_clazz.newInstance();
            DefaultContext context = new DefaultContext();
            context.put((Object)"urn:meta:profile.name", (Object)name);
            context.put((Object)"urn:meta:profile.parameters", (Object)params);
            context.put((Object)"urn:meta:profile.configuration", configuration);
            context.put((Object)"urn:meta:profile.context", (Object)contextDirective);
            context.put((Object)"urn:meta:profile.categories", (Object)categories);
            context.put((Object)"urn:meta:profile.type", (Object)type);
            context.put((Object)"urn:meta:profile.mode", (Object)mode);
            context.put((Object)"urn:meta:profile.activation", (Object)new Boolean(activation));
            profile.contextualize((Context)context);
            return profile;
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to build profile using class: " + this.m_base;
            throw new ModelRuntimeException(error, e);
        }
    }

    protected boolean getActivationPolicy(Configuration config) {
        String value = config.getAttribute("activation", null);
        if (value == null) {
            return false;
        }
        String string = value.toLowerCase().trim();
        if (string.equals("startup")) {
            return true;
        }
        return string.equals("true");
    }

    private Profile createImplicitProfile(Type type) throws Exception {
        ContextDirective contextDirective = new ContextDirective(null, new Import[0], new Entry[0]);
        Configuration defaults = type.getConfiguration();
        if (defaults == null) {
            defaults = new DefaultConfiguration("default", null);
        }
        LoggingDirective categories = this.createDefaultLoggingDirective(type);
        try {
            Profile profile = (Profile)this.m_clazz.newInstance();
            DefaultContext context = new DefaultContext();
            context.put((Object)"urn:meta:profile.configuration", (Object)defaults);
            context.put((Object)"urn:meta:profile.context", (Object)contextDirective);
            context.put((Object)"urn:meta:profile.categories", (Object)categories);
            context.put((Object)"urn:meta:profile.type", (Object)type);
            context.put((Object)"urn:meta:profile.mode", (Object)Mode.IMPLICIT);
            profile.contextualize((Context)context);
            return profile;
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to build implicit profile using class: " + this.m_base;
            throw new ModelRuntimeException(error, e);
        }
    }

    public ContextDirective createContextDirective(Configuration config) throws ConfigurationException {
        String classname = config.getAttribute("class", null);
        Import[] imports = this.createImports(config.getChildren("import"));
        Entry[] entries = this.createEntries(config.getChildren("entry"));
        return new ContextDirective(classname, imports, entries);
    }

    protected Import[] createImports(Configuration[] configs) throws ConfigurationException {
        ArrayList<Import> list = new ArrayList<Import>();
        int i = 0;
        while (i < configs.length) {
            list.add(this.createImport(configs[i]));
            ++i;
        }
        return list.toArray(new Import[0]);
    }

    protected Import createImport(Configuration config) throws ConfigurationException {
        String key = config.getAttribute("key");
        String path = config.getAttribute("name", null);
        return new Import(key, path);
    }

    protected Entry[] createEntries(Configuration[] configs) throws ConfigurationException {
        ArrayList<Entry> list = new ArrayList<Entry>();
        int i = 0;
        while (i < configs.length) {
            Entry entry = this.createEntry(configs[i]);
            list.add(entry);
            ++i;
        }
        return list.toArray(new Entry[0]);
    }

    protected Entry createEntry(Configuration config) throws ConfigurationException {
        String key = config.getAttribute("key");
        String classname = config.getAttribute("class", "java.lang.String");
        String value = config.getValue(null);
        if (value != null) {
            return new Entry(key, classname, value);
        }
        Configuration[] params = config.getChildren("param");
        Parameter[] parameters = this.createParameters(params);
        return new Entry(key, classname, parameters);
    }

    protected Parameter[] createParameters(Configuration[] configs) throws ConfigurationException {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        int i = 0;
        while (i < configs.length) {
            Parameter parameter = this.createParameter(configs[i]);
            list.add(parameter);
            ++i;
        }
        return list.toArray(new Parameter[0]);
    }

    protected Parameter createParameter(Configuration config) throws ConfigurationException {
        String classname = config.getAttribute("class", "java.lang.String");
        String value = config.getValue(null);
        if (value != null) {
            return new Parameter(classname, value);
        }
        Configuration[] params = config.getChildren("param");
        Parameter[] parameters = this.createParameters(params);
        return new Parameter(classname, parameters);
    }

    public LoggingDirective createLoggingDirective(String name, Configuration config) throws Exception {
        return this.createLoggingDirective(name, config, null);
    }

    public LoggingDirective createLoggingDirective(String name, Configuration config, LoggingDirective logging) throws Exception {
        return this.createLoggingDirective(name, null, config, logging);
    }

    public LoggingDirective createLoggingDirective(String name, String level, Configuration config, LoggingDirective logging) throws Exception {
        String priority = config.getAttribute("priority", null);
        if (logging != null) {
            if (logging.getPriority() != null) {
                priority = logging.getPriority();
            }
        } else if (level != null) {
            priority = level;
        }
        String target = config.getAttribute("target", null);
        if (logging != null && logging.getTarget() != null) {
            target = logging.getTarget();
        }
        ArrayList<Category> list = new ArrayList<Category>();
        Configuration[] configs = config.getChildren("category");
        int i = 0;
        while (i < configs.length) {
            Category category = this.createCategory(level, configs[i], logging);
            list.add(category);
            ++i;
        }
        Category[] categories = list.toArray(new Category[0]);
        return new LoggingDirective(name, priority, target, categories);
    }

    public Category createCategory(Configuration config) throws ConfigurationException {
        return this.createCategory(null, config);
    }

    protected Category createCategory(String level, Configuration config) throws ConfigurationException {
        return this.createCategory(level, config, null);
    }

    protected Category createCategory(String level, Configuration config, LoggingDirective logging) throws ConfigurationException {
        String name = config.getAttribute("name", "");
        String priority = level != null ? level : config.getAttribute("priority", null);
        String target = config.getAttribute("target", null);
        if (logging != null && logging.getCategory(name) != null) {
            Category cat = logging.getCategory(name);
            if (cat.getPriority() != null) {
                priority = cat.getPriority();
            }
            if (cat.getTarget() != null) {
                target = cat.getTarget();
            }
        }
        return new Category(name, priority, target);
    }

    protected Category createCategory(Configuration config, String def) throws ConfigurationException {
        String name = config.getAttribute("name", def);
        String priority = config.getAttribute("priority", null);
        String target = config.getAttribute("target", null);
        return new Category(name, priority, target);
    }

    protected LoggingDirective createDefaultLoggingDirective(Type type) {
        String name = type.getInfo().getName();
        return new LoggingDirective(name, null, null, new Category[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

