/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.model.verifier;

import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.model.Profile;
import org.apache.avalon.meta.verifier.ComponentVerifier;
import org.apache.avalon.meta.verifier.VerifyException;

public class ProfileVerifier {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$model$verifier$ProfileVerifier == null ? (class$org$apache$avalon$meta$model$verifier$ProfileVerifier = ProfileVerifier.class$("org.apache.avalon.meta.model.verifier.ProfileVerifier")) : class$org$apache$avalon$meta$model$verifier$ProfileVerifier));
    private final ComponentVerifier m_verifier;
    static /* synthetic */ Class class$org$apache$avalon$meta$model$verifier$ProfileVerifier;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Contextualizable;

    public ProfileVerifier() {
        this(new ComponentVerifier());
    }

    public ProfileVerifier(ComponentVerifier verifier) {
        if (null == verifier) {
            throw new NullPointerException("verifier");
        }
        this.m_verifier = verifier;
    }

    public void verifyType(Profile profile, ClassLoader classLoader) throws VerifyException {
        Class clazz = this.getClass(classLoader, profile);
        this.verifyType(profile, clazz);
    }

    public void verifyType(Profile profile, Class clazz) throws VerifyException {
        String name = profile.getName();
        Class[] interfaces = this.getServiceClasses(name, profile.getType().getServices(), clazz.getClassLoader());
        Class[] phases = this.getPhaseClasses(name, profile.getType().getStages(), clazz.getClassLoader());
        this.m_verifier.verifyType(name, clazz, interfaces, phases);
    }

    protected void verifyContextPresence(Profile profile, Class clazz) throws VerifyException {
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        Type info = profile.getType();
        ContextDescriptor context = info.getContext();
        int count = context.getEntries().length;
        if (!(class$org$apache$avalon$framework$context$Contextualizable == null ? (class$org$apache$avalon$framework$context$Contextualizable = ProfileVerifier.class$("org.apache.avalon.framework.context.Contextualizable")) : class$org$apache$avalon$framework$context$Contextualizable).isAssignableFrom(clazz) && 0 != count) {
            String message = REZ.getString("metadata.declare-uneeded-entrys.error", (Object)profile.getName(), (Object)clazz.getName());
            throw new VerifyException(message);
        }
    }

    protected Class[] getServiceClasses(String name, ServiceDescriptor[] services, ClassLoader classLoader) throws VerifyException {
        Class[] classes = new Class[services.length];
        int i = 0;
        while (i < services.length) {
            ReferenceDescriptor service = services[i].getReference();
            String classname = service.getClassname();
            try {
                classes[i] = classLoader.loadClass(classname);
            }
            catch (Throwable t) {
                String message = REZ.getString("metadata.bad-service-class.error", (Object)name, (Object)classname, (Object)t.toString());
                throw new VerifyException(message, t);
            }
            ++i;
        }
        return classes;
    }

    protected Class[] getPhaseClasses(String name, StageDescriptor[] phases, ClassLoader classLoader) throws VerifyException {
        Class[] classes = new Class[phases.length];
        int i = 0;
        while (i < phases.length) {
            ReferenceDescriptor service = phases[i].getReference();
            String classname = service.getClassname();
            try {
                classes[i] = classLoader.loadClass(classname);
            }
            catch (Throwable t) {
                String message = REZ.getString("metadata.bad-phase-class.error", (Object)name, (Object)classname, (Object)t.toString());
                throw new VerifyException(message, t);
            }
            ++i;
        }
        return classes;
    }

    private Class getClass(ClassLoader classLoader, Profile profile) throws VerifyException {
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(this.getClassname(profile));
        }
        catch (Exception e) {
            String message = REZ.getString("assembly.bad-class.error", (Object)profile.getName(), (Object)this.getClassname(profile), (Object)e.toString());
            throw new VerifyException(message);
        }
        return clazz;
    }

    private String getClassname(Profile profile) {
        return profile.getType().getInfo().getClassname();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

