// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.paginators

import aws.sdk.kotlin.services.account.AccountClient
import aws.sdk.kotlin.services.account.model.ListRegionsRequest
import aws.sdk.kotlin.services.account.model.ListRegionsResponse
import aws.sdk.kotlin.services.account.model.Region
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListRegionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRegionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRegionsResponse]
 */
public fun AccountClient.listRegionsPaginated(initialRequest: ListRegionsRequest = ListRegionsRequest { }): Flow<ListRegionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRegionsPaginated.listRegions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRegionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRegionsResponse]
 */
public fun AccountClient.listRegionsPaginated(block: ListRegionsRequest.Builder.() -> Unit): Flow<ListRegionsResponse> =
    listRegionsPaginated(ListRegionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRegionsPaginated]
 * to access the nested member [Region]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Region]
 */
@JvmName("listRegionsResponseRegion")
public fun Flow<ListRegionsResponse>.regions(): Flow<Region> =
    transform() { response ->
        response.regions?.forEach {
            emit(it)
        }
    }
