// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.endpoints

import aws.sdk.kotlin.services.account.endpoints.internal.partition
import aws.smithy.kotlin.runtime.businessmetrics.ServiceEndpointOverride
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.http.auth.sigV4
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultAccountEndpointProvider: AccountEndpointProvider {
    public override suspend fun resolveEndpoint(params: AccountEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
                attributes = attributesOf {
                    ServiceEndpointOverride to true
                },
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        partitionResult?.name == "aws" &&
                        params.useFips == false &&
                        params.useDualStack == false
                    ) {
                        return Endpoint(
                            Url.parse("https://account.us-east-1.amazonaws.com"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    sigV4(
                                        serviceName = "account",
                                        disableDoubleUriEncode = false,
                                        signingRegion = "us-east-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        partitionResult?.name == "aws-cn" &&
                        params.useFips == false &&
                        params.useDualStack == false
                    ) {
                        return Endpoint(
                            Url.parse("https://account.cn-northwest-1.amazonaws.com.cn"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    sigV4(
                                        serviceName = "account",
                                        disableDoubleUriEncode = false,
                                        signingRegion = "cn-northwest-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://account-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            partitionResult?.supportsFIPS == true
                        ) {
                            return Endpoint(
                                Url.parse("https://account-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://account.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://account.${params.region}.${partitionResult?.dnsSuffix}"),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
