// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.endpoints

import aws.sdk.kotlin.services.account.endpoints.internal.partition
import aws.smithy.kotlin.runtime.businessmetrics.ServiceEndpointOverride
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.http.auth.sigV4
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultAccountEndpointProvider: AccountEndpointProvider {
    public override suspend fun resolveEndpoint(params: AccountEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
                attributes = attributesOf {
                    ServiceEndpointOverride to true
                },
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://account-fips.${partitionResult?.implicitGlobalRegion}.${partitionResult?.dualStackDnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = null,
                                            disableDoubleUriEncode = false,
                                            signingRegion = "${partitionResult?.implicitGlobalRegion}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true &&
                        params.useDualStack == false
                    ) {
                        if (
                            partitionResult?.supportsFIPS == true
                        ) {
                            return Endpoint(
                                Url.parse("https://account-fips.${partitionResult?.implicitGlobalRegion}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = null,
                                            disableDoubleUriEncode = false,
                                            signingRegion = "${partitionResult?.implicitGlobalRegion}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useFips == false &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://account.${partitionResult?.implicitGlobalRegion}.${partitionResult?.dualStackDnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = null,
                                            disableDoubleUriEncode = false,
                                            signingRegion = "${partitionResult?.implicitGlobalRegion}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://account.${partitionResult?.implicitGlobalRegion}.${partitionResult?.dnsSuffix}"),
                        attributes = attributesOf {
                            SigningContextAttributeKey to listOf(
                                sigV4(
                                    serviceName = null,
                                    disableDoubleUriEncode = false,
                                    signingRegion = "${partitionResult?.implicitGlobalRegion}",
                                ),
                            )
                        },
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
