// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListRegionsRequest private constructor(builder: Builder) {
    /**
     * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don't specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the [organization's management account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account) or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have [all features enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html), and the organization must have [trusted access](https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html) enabled for the Account Management service, and optionally a [delegated admin](https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html) account assigned.
     *
     * The management account can't specify its own `AccountId`. It must call the operation in standalone context by not including the `AccountId` parameter.
     *
     * To call this operation on an account that is not a member of an organization, don't specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The total number of items to return in the command’s output. If the total number of items available is more than the value specified, a `NextToken` is provided in the command’s output. To resume pagination, provide the `NextToken` value in the `starting-token` argument of a subsequent command. Do not use the `NextToken` response element directly outside of the Amazon Web Services CLI. For usage examples, see [Pagination](http://docs.aws.amazon.com/cli/latest/userguide/pagination.html) in the *Amazon Web Services Command Line Interface User Guide*.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token used to specify where to start paginating. This is the `NextToken` from a previously truncated response. For usage examples, see [Pagination](http://docs.aws.amazon.com/cli/latest/userguide/pagination.html) in the *Amazon Web Services Command Line Interface User Guide*.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the list of Regions for a given account. For example, passing in a value of ENABLING will only return a list of Regions with a Region status of ENABLING.
     */
    public val regionOptStatusContains: List<RegionOptStatus>? = builder.regionOptStatusContains

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.account.model.ListRegionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRegionsRequest(")
        append("accountId=$accountId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("regionOptStatusContains=$regionOptStatusContains")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (regionOptStatusContains?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRegionsRequest

        if (accountId != other.accountId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (regionOptStatusContains != other.regionOptStatusContains) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.account.model.ListRegionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don't specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the [organization's management account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account) or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have [all features enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html), and the organization must have [trusted access](https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html) enabled for the Account Management service, and optionally a [delegated admin](https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html) account assigned.
         *
         * The management account can't specify its own `AccountId`. It must call the operation in standalone context by not including the `AccountId` parameter.
         *
         * To call this operation on an account that is not a member of an organization, don't specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.
         */
        public var accountId: kotlin.String? = null
        /**
         * The total number of items to return in the command’s output. If the total number of items available is more than the value specified, a `NextToken` is provided in the command’s output. To resume pagination, provide the `NextToken` value in the `starting-token` argument of a subsequent command. Do not use the `NextToken` response element directly outside of the Amazon Web Services CLI. For usage examples, see [Pagination](http://docs.aws.amazon.com/cli/latest/userguide/pagination.html) in the *Amazon Web Services Command Line Interface User Guide*.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token used to specify where to start paginating. This is the `NextToken` from a previously truncated response. For usage examples, see [Pagination](http://docs.aws.amazon.com/cli/latest/userguide/pagination.html) in the *Amazon Web Services Command Line Interface User Guide*.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the list of Regions for a given account. For example, passing in a value of ENABLING will only return a list of Regions with a Region status of ENABLING.
         */
        public var regionOptStatusContains: List<RegionOptStatus>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.account.model.ListRegionsRequest) : this() {
            this.accountId = x.accountId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.regionOptStatusContains = x.regionOptStatusContains
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.account.model.ListRegionsRequest = ListRegionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
