// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.model

import aws.smithy.kotlin.runtime.SdkDsl

public class AcceptPrimaryEmailUpdateRequest private constructor(builder: Builder) {
    /**
     * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. To use this parameter, the caller must be an identity in the [organization's management account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account) or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have [all features enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html), and the organization must have [trusted access](https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html) enabled for the Account Management service, and optionally a [delegated admin](https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html) account assigned.
     *
     * This operation can only be called from the management account or the delegated administrator account of an organization for a member account.
     *
     * The management account can't specify its own `AccountId`.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The OTP code sent to the `PrimaryEmail` specified on the `StartPrimaryEmailUpdate` API call.
     */
    public val otp: kotlin.String? = builder.otp
    /**
     * The new primary email address for use with the specified account. This must match the `PrimaryEmail` from the `StartPrimaryEmailUpdate` API call.
     */
    public val primaryEmail: kotlin.String? = builder.primaryEmail

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.account.model.AcceptPrimaryEmailUpdateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AcceptPrimaryEmailUpdateRequest(")
        append("accountId=$accountId,")
        append("otp=*** Sensitive Data Redacted ***,")
        append("primaryEmail=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (otp?.hashCode() ?: 0)
        result = 31 * result + (primaryEmail?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AcceptPrimaryEmailUpdateRequest

        if (accountId != other.accountId) return false
        if (otp != other.otp) return false
        if (primaryEmail != other.primaryEmail) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.account.model.AcceptPrimaryEmailUpdateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. To use this parameter, the caller must be an identity in the [organization's management account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account) or a delegated administrator account. The specified account ID must be a member account in the same organization. The organization must have [all features enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html), and the organization must have [trusted access](https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html) enabled for the Account Management service, and optionally a [delegated admin](https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html) account assigned.
         *
         * This operation can only be called from the management account or the delegated administrator account of an organization for a member account.
         *
         * The management account can't specify its own `AccountId`.
         */
        public var accountId: kotlin.String? = null
        /**
         * The OTP code sent to the `PrimaryEmail` specified on the `StartPrimaryEmailUpdate` API call.
         */
        public var otp: kotlin.String? = null
        /**
         * The new primary email address for use with the specified account. This must match the `PrimaryEmail` from the `StartPrimaryEmailUpdate` API call.
         */
        public var primaryEmail: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.account.model.AcceptPrimaryEmailUpdateRequest) : this() {
            this.accountId = x.accountId
            this.otp = x.otp
            this.primaryEmail = x.primaryEmail
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.account.model.AcceptPrimaryEmailUpdateRequest = AcceptPrimaryEmailUpdateRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
