// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.model



class PutAlternateContactRequest private constructor(builder: Builder) {
    /**
     * Specifies the 12 digit account ID number of the Amazon Web Services account that
     * you want to access or modify with this operation.
     * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
     * identity used to call the operation.
     * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
     * the specified account ID must be a member account in the same organization. The
     * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
     * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
     * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
     * assigned.
     * The management account can't specify its own AccountId; it must call
     * the operation in standalone context by not including the AccountId
     * parameter.
     * To call this operation on an account that is not a member of an organization, then
     * don't specify this parameter, and call the operation using an identity belonging to
     * the account whose contacts you wish to retrieve or modify.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * Specifies which alternate contact you want to create or update.
     */
    val alternateContactType: aws.sdk.kotlin.services.account.model.AlternateContactType? = builder.alternateContactType
    /**
     * Specifies an email address for the alternate contact.
     */
    val emailAddress: kotlin.String? = builder.emailAddress
    /**
     * Specifies a name for the alternate contact.
     */
    val name: kotlin.String? = builder.name
    /**
     * Specifies a phone number for the alternate contact.
     */
    val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * Specifies a title for the alternate contact.
     */
    val title: kotlin.String? = builder.title

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.account.model.PutAlternateContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutAlternateContactRequest(")
        append("accountId=$accountId,")
        append("alternateContactType=$alternateContactType,")
        append("emailAddress=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("phoneNumber=*** Sensitive Data Redacted ***,")
        append("title=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (alternateContactType?.hashCode() ?: 0)
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutAlternateContactRequest

        if (accountId != other.accountId) return false
        if (alternateContactType != other.alternateContactType) return false
        if (emailAddress != other.emailAddress) return false
        if (name != other.name) return false
        if (phoneNumber != other.phoneNumber) return false
        if (title != other.title) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.account.model.PutAlternateContactRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the 12 digit account ID number of the Amazon Web Services account that
         * you want to access or modify with this operation.
         * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
         * identity used to call the operation.
         * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
         * the specified account ID must be a member account in the same organization. The
         * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
         * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
         * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
         * assigned.
         * The management account can't specify its own AccountId; it must call
         * the operation in standalone context by not including the AccountId
         * parameter.
         * To call this operation on an account that is not a member of an organization, then
         * don't specify this parameter, and call the operation using an identity belonging to
         * the account whose contacts you wish to retrieve or modify.
         */
        var accountId: kotlin.String? = null
        /**
         * Specifies which alternate contact you want to create or update.
         */
        var alternateContactType: aws.sdk.kotlin.services.account.model.AlternateContactType? = null
        /**
         * Specifies an email address for the alternate contact.
         */
        var emailAddress: kotlin.String? = null
        /**
         * Specifies a name for the alternate contact.
         */
        var name: kotlin.String? = null
        /**
         * Specifies a phone number for the alternate contact.
         */
        var phoneNumber: kotlin.String? = null
        /**
         * Specifies a title for the alternate contact.
         */
        var title: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.account.model.PutAlternateContactRequest) : this() {
            this.accountId = x.accountId
            this.alternateContactType = x.alternateContactType
            this.emailAddress = x.emailAddress
            this.name = x.name
            this.phoneNumber = x.phoneNumber
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.account.model.PutAlternateContactRequest = PutAlternateContactRequest(this)
    }
}
