// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.model



class GetAlternateContactRequest private constructor(builder: Builder) {
    /**
     * Specifies the 12 digit account ID number of the Amazon Web Services account that
     * you want to access or modify with this operation.
     * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
     * identity used to call the operation.
     * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
     * the specified account ID must be a member account in the same organization. The
     * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
     * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
     * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
     * assigned.
     *
     * The management account can't specify its own AccountId; it must call
     * the operation in standalone context by not including the AccountId
     * parameter.
     *
     * To call this operation on an account that is not a member of an organization, then
     * don't specify this parameter, and call the operation using an identity belonging to
     * the account whose contacts you wish to retrieve or modify.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * Specifies which alternate contact you want to retrieve.
     */
    val alternateContactType: aws.sdk.kotlin.services.account.model.AlternateContactType? = builder.alternateContactType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.account.model.GetAlternateContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAlternateContactRequest(")
        append("accountId=$accountId,")
        append("alternateContactType=$alternateContactType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (alternateContactType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAlternateContactRequest

        if (accountId != other.accountId) return false
        if (alternateContactType != other.alternateContactType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.account.model.GetAlternateContactRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the 12 digit account ID number of the Amazon Web Services account that
         * you want to access or modify with this operation.
         * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
         * identity used to call the operation.
         * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
         * the specified account ID must be a member account in the same organization. The
         * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
         * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
         * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
         * assigned.
         *
         * The management account can't specify its own AccountId; it must call
         * the operation in standalone context by not including the AccountId
         * parameter.
         *
         * To call this operation on an account that is not a member of an organization, then
         * don't specify this parameter, and call the operation using an identity belonging to
         * the account whose contacts you wish to retrieve or modify.
         */
        var accountId: kotlin.String? = null
        /**
         * Specifies which alternate contact you want to retrieve.
         */
        var alternateContactType: aws.sdk.kotlin.services.account.model.AlternateContactType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.account.model.GetAlternateContactRequest) : this() {
            this.accountId = x.accountId
            this.alternateContactType = x.alternateContactType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.account.model.GetAlternateContactRequest = GetAlternateContactRequest(this)
    }
}
