// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.endpoints

import aws.sdk.kotlin.runtime.endpoint.AuthScheme
import aws.sdk.kotlin.runtime.endpoint.AuthSchemesAttributeKey
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.util.Attributes
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region aws-cn-global with FIPS disabled and DualStack disabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            region = "aws-cn-global"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://account.cn-northwest-1.amazonaws.com.cn"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "account",
                            disableDoubleEncoding = false,
                            signingRegion = "cn-northwest-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region aws-global with FIPS disabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            region = "aws-global"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://account.us-east-1.amazonaws.com"),
            attributes = Attributes().apply {
                set(
                    AuthSchemesAttributeKey,
                    listOf(
                        AuthScheme.SigV4(
                            signingName = "account",
                            disableDoubleEncoding = false,
                            signingRegion = "us-east-1",
                        ),
                    ),
                )
            },
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips disabled and dualstack disabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
