// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.endpoints

import aws.sdk.kotlin.runtime.endpoint.AuthScheme
import aws.sdk.kotlin.runtime.endpoint.AuthSchemesAttributeKey
import aws.sdk.kotlin.services.account.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.util.Attributes

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEndpointProvider: EndpointProvider {
    public override suspend fun resolveEndpoint(params: EndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        partitionResult?.name == "aws"
                    ) {
                        if (
                            params.useFips == true &&
                            params.useDualStack == true
                        ) {
                            if (
                                true == partitionResult?.supportsFIPS &&
                                true == partitionResult?.supportsDualStack
                            ) {
                                return Endpoint(
                                    Url.parse("https://account-fips.${params.region}.api.aws"),
                                )
                            }
                            throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                        }
                        if (
                            params.useFips == true
                        ) {
                            if (
                                true == partitionResult?.supportsFIPS
                            ) {
                                return Endpoint(
                                    Url.parse("https://account-fips.${params.region}.amazonaws.com"),
                                )
                            }
                            throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                        }
                        if (
                            params.useDualStack == true
                        ) {
                            if (
                                true == partitionResult?.supportsDualStack
                            ) {
                                return Endpoint(
                                    Url.parse("https://account.${params.region}.api.aws"),
                                )
                            }
                            throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                        }
                        return Endpoint(
                            Url.parse("https://account.us-east-1.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "account",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        partitionResult?.name == "aws-cn"
                    ) {
                        if (
                            params.useFips == true &&
                            params.useDualStack == true
                        ) {
                            if (
                                true == partitionResult?.supportsFIPS &&
                                true == partitionResult?.supportsDualStack
                            ) {
                                return Endpoint(
                                    Url.parse("https://account-fips.${params.region}.api.amazonwebservices.com.cn"),
                                )
                            }
                            throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                        }
                        if (
                            params.useFips == true
                        ) {
                            if (
                                true == partitionResult?.supportsFIPS
                            ) {
                                return Endpoint(
                                    Url.parse("https://account-fips.${params.region}.amazonaws.com.cn"),
                                )
                            }
                            throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                        }
                        if (
                            params.useDualStack == true
                        ) {
                            if (
                                true == partitionResult?.supportsDualStack
                            ) {
                                return Endpoint(
                                    Url.parse("https://account.${params.region}.api.amazonwebservices.com.cn"),
                                )
                            }
                            throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                        }
                        return Endpoint(
                            Url.parse("https://account.cn-northwest-1.amazonaws.com.cn"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "account",
                                            disableDoubleEncoding = false,
                                            signingRegion = "cn-northwest-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://account-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://account-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://account.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    if (
                        params.region == "aws-global"
                    ) {
                        return Endpoint(
                            Url.parse("https://account.us-east-1.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "account",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "aws-cn-global"
                    ) {
                        return Endpoint(
                            Url.parse("https://account.cn-northwest-1.amazonaws.com.cn"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "account",
                                            disableDoubleEncoding = false,
                                            signingRegion = "cn-northwest-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    return Endpoint(
                        Url.parse("https://account.${params.region}.${partitionResult?.dnsSuffix}"),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
