// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.account.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.account.endpoints.EndpointParameters
import aws.sdk.kotlin.services.account.endpoints.EndpointProvider
import aws.sdk.kotlin.services.account.model.DeleteAlternateContactRequest
import aws.sdk.kotlin.services.account.model.DeleteAlternateContactResponse
import aws.sdk.kotlin.services.account.model.DisableRegionRequest
import aws.sdk.kotlin.services.account.model.DisableRegionResponse
import aws.sdk.kotlin.services.account.model.EnableRegionRequest
import aws.sdk.kotlin.services.account.model.EnableRegionResponse
import aws.sdk.kotlin.services.account.model.GetAlternateContactRequest
import aws.sdk.kotlin.services.account.model.GetAlternateContactResponse
import aws.sdk.kotlin.services.account.model.GetContactInformationRequest
import aws.sdk.kotlin.services.account.model.GetContactInformationResponse
import aws.sdk.kotlin.services.account.model.GetRegionOptStatusRequest
import aws.sdk.kotlin.services.account.model.GetRegionOptStatusResponse
import aws.sdk.kotlin.services.account.model.ListRegionsRequest
import aws.sdk.kotlin.services.account.model.ListRegionsResponse
import aws.sdk.kotlin.services.account.model.PutAlternateContactRequest
import aws.sdk.kotlin.services.account.model.PutAlternateContactResponse
import aws.sdk.kotlin.services.account.model.PutContactInformationRequest
import aws.sdk.kotlin.services.account.model.PutContactInformationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * Operations for Amazon Web Services Account Management
 */
public interface AccountClient : SdkClient {
    /**
     * AccountClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AccountClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AccountClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AccountClient = DefaultAccountClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Account"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified alternate contact from an Amazon Web Services account.
     *
     * For complete details about how to use the alternate contact operations, see [Access or updating the alternate contacts](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
     *
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see [Enabling trusted access for Amazon Web Services Account Management](https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html).
     */
    public suspend fun deleteAlternateContact(input: DeleteAlternateContactRequest): DeleteAlternateContactResponse

    /**
     * Disables (opts-out) a particular Region for an account.
     */
    public suspend fun disableRegion(input: DisableRegionRequest): DisableRegionResponse

    /**
     * Enables (opts-in) a particular Region for an account.
     */
    public suspend fun enableRegion(input: EnableRegionRequest): EnableRegionResponse

    /**
     * Retrieves the specified alternate contact attached to an Amazon Web Services account.
     *
     * For complete details about how to use the alternate contact operations, see [Access or updating the alternate contacts](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
     *
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see [Enabling trusted access for Amazon Web Services Account Management](https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html).
     */
    public suspend fun getAlternateContact(input: GetAlternateContactRequest): GetAlternateContactResponse

    /**
     * Retrieves the primary contact information of an Amazon Web Services account.
     *
     * For complete details about how to use the primary contact operations, see [Update the primary and alternate contact information](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
     */
    public suspend fun getContactInformation(input: GetContactInformationRequest = GetContactInformationRequest {}): GetContactInformationResponse

    /**
     * Retrieves the opt-in status of a particular Region.
     */
    public suspend fun getRegionOptStatus(input: GetRegionOptStatusRequest): GetRegionOptStatusResponse

    /**
     * Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be filtered by the `region-opt-status-contains` parameter.
     */
    public suspend fun listRegions(input: ListRegionsRequest = ListRegionsRequest {}): ListRegionsResponse

    /**
     * Modifies the specified alternate contact attached to an Amazon Web Services account.
     *
     * For complete details about how to use the alternate contact operations, see [Access or updating the alternate contacts](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
     *
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see [Enabling trusted access for Amazon Web Services Account Management](https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html).
     */
    public suspend fun putAlternateContact(input: PutAlternateContactRequest): PutAlternateContactResponse

    /**
     * Updates the primary contact information of an Amazon Web Services account.
     *
     * For complete details about how to use the primary contact operations, see [Update the primary and alternate contact information](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
     */
    public suspend fun putContactInformation(input: PutContactInformationRequest): PutContactInformationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AccountClient.withConfig(block: AccountClient.Config.Builder.() -> Unit): AccountClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAccountClient(newConfig)
}

/**
 * Deletes the specified alternate contact from an Amazon Web Services account.
 *
 * For complete details about how to use the alternate contact operations, see [Access or updating the alternate contacts](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
 *
 * Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see [Enabling trusted access for Amazon Web Services Account Management](https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html).
 */
public suspend inline fun AccountClient.deleteAlternateContact(crossinline block: DeleteAlternateContactRequest.Builder.() -> Unit): DeleteAlternateContactResponse = deleteAlternateContact(DeleteAlternateContactRequest.Builder().apply(block).build())

/**
 * Disables (opts-out) a particular Region for an account.
 */
public suspend inline fun AccountClient.disableRegion(crossinline block: DisableRegionRequest.Builder.() -> Unit): DisableRegionResponse = disableRegion(DisableRegionRequest.Builder().apply(block).build())

/**
 * Enables (opts-in) a particular Region for an account.
 */
public suspend inline fun AccountClient.enableRegion(crossinline block: EnableRegionRequest.Builder.() -> Unit): EnableRegionResponse = enableRegion(EnableRegionRequest.Builder().apply(block).build())

/**
 * Retrieves the specified alternate contact attached to an Amazon Web Services account.
 *
 * For complete details about how to use the alternate contact operations, see [Access or updating the alternate contacts](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
 *
 * Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see [Enabling trusted access for Amazon Web Services Account Management](https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html).
 */
public suspend inline fun AccountClient.getAlternateContact(crossinline block: GetAlternateContactRequest.Builder.() -> Unit): GetAlternateContactResponse = getAlternateContact(GetAlternateContactRequest.Builder().apply(block).build())

/**
 * Retrieves the primary contact information of an Amazon Web Services account.
 *
 * For complete details about how to use the primary contact operations, see [Update the primary and alternate contact information](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
 */
public suspend inline fun AccountClient.getContactInformation(crossinline block: GetContactInformationRequest.Builder.() -> Unit): GetContactInformationResponse = getContactInformation(GetContactInformationRequest.Builder().apply(block).build())

/**
 * Retrieves the opt-in status of a particular Region.
 */
public suspend inline fun AccountClient.getRegionOptStatus(crossinline block: GetRegionOptStatusRequest.Builder.() -> Unit): GetRegionOptStatusResponse = getRegionOptStatus(GetRegionOptStatusRequest.Builder().apply(block).build())

/**
 * Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be filtered by the `region-opt-status-contains` parameter.
 */
public suspend inline fun AccountClient.listRegions(crossinline block: ListRegionsRequest.Builder.() -> Unit): ListRegionsResponse = listRegions(ListRegionsRequest.Builder().apply(block).build())

/**
 * Modifies the specified alternate contact attached to an Amazon Web Services account.
 *
 * For complete details about how to use the alternate contact operations, see [Access or updating the alternate contacts](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
 *
 * Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see [Enabling trusted access for Amazon Web Services Account Management](https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html).
 */
public suspend inline fun AccountClient.putAlternateContact(crossinline block: PutAlternateContactRequest.Builder.() -> Unit): PutAlternateContactResponse = putAlternateContact(PutAlternateContactRequest.Builder().apply(block).build())

/**
 * Updates the primary contact information of an Amazon Web Services account.
 *
 * For complete details about how to use the primary contact operations, see [Update the primary and alternate contact information](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html).
 */
public suspend inline fun AccountClient.putContactInformation(crossinline block: PutContactInformationRequest.Builder.() -> Unit): PutContactInformationResponse = putContactInformation(PutContactInformationRequest.Builder().apply(block).build())
