// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.transform

import aws.sdk.kotlin.services.account.model.AccountException
import aws.sdk.kotlin.services.account.model.GetRegionOptStatusResponse
import aws.sdk.kotlin.services.account.model.RegionOptStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRegionOptStatusOperationDeserializer: HttpDeserialize<GetRegionOptStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRegionOptStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetRegionOptStatusError(context, response)
        }
        val builder = GetRegionOptStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRegionOptStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRegionOptStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AccountException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AccountException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRegionOptStatusOperationBody(builder: GetRegionOptStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REGIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RegionName"))
    val REGIONOPTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RegionOptStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REGIONNAME_DESCRIPTOR)
        field(REGIONOPTSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REGIONNAME_DESCRIPTOR.index -> builder.regionName = deserializeString()
                REGIONOPTSTATUS_DESCRIPTOR.index -> builder.regionOptStatus = deserializeString().let { RegionOptStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
