// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.model



/**
 * Contains the details of the primary contact information associated with an Amazon Web Services account.
 */
public class ContactInformation private constructor(builder: Builder) {
    /**
     * The first line of the primary contact address.
     */
    public val addressLine1: kotlin.String? = builder.addressLine1
    /**
     * The second line of the primary contact address, if any.
     */
    public val addressLine2: kotlin.String? = builder.addressLine2
    /**
     * The third line of the primary contact address, if any.
     */
    public val addressLine3: kotlin.String? = builder.addressLine3
    /**
     * The city of the primary contact address.
     */
    public val city: kotlin.String? = builder.city
    /**
     * The name of the company associated with the primary contact information, if any.
     */
    public val companyName: kotlin.String? = builder.companyName
    /**
     * The ISO-3166 two-letter country code for the primary contact address.
     */
    public val countryCode: kotlin.String? = builder.countryCode
    /**
     * The district or county of the primary contact address, if any.
     */
    public val districtOrCounty: kotlin.String? = builder.districtOrCounty
    /**
     * The full name of the primary contact address.
     */
    public val fullName: kotlin.String? = builder.fullName
    /**
     * The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The postal code of the primary contact address.
     */
    public val postalCode: kotlin.String? = builder.postalCode
    /**
     * The state or region of the primary contact address. This field is required in selected countries.
     */
    public val stateOrRegion: kotlin.String? = builder.stateOrRegion
    /**
     * The URL of the website associated with the primary contact information, if any.
     */
    public val websiteUrl: kotlin.String? = builder.websiteUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.account.model.ContactInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContactInformation(")
        append("addressLine1=*** Sensitive Data Redacted ***,")
        append("addressLine2=*** Sensitive Data Redacted ***,")
        append("addressLine3=*** Sensitive Data Redacted ***,")
        append("city=*** Sensitive Data Redacted ***,")
        append("companyName=*** Sensitive Data Redacted ***,")
        append("countryCode=*** Sensitive Data Redacted ***,")
        append("districtOrCounty=*** Sensitive Data Redacted ***,")
        append("fullName=*** Sensitive Data Redacted ***,")
        append("phoneNumber=*** Sensitive Data Redacted ***,")
        append("postalCode=*** Sensitive Data Redacted ***,")
        append("stateOrRegion=*** Sensitive Data Redacted ***,")
        append("websiteUrl=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressLine1?.hashCode() ?: 0
        result = 31 * result + (addressLine2?.hashCode() ?: 0)
        result = 31 * result + (addressLine3?.hashCode() ?: 0)
        result = 31 * result + (city?.hashCode() ?: 0)
        result = 31 * result + (companyName?.hashCode() ?: 0)
        result = 31 * result + (countryCode?.hashCode() ?: 0)
        result = 31 * result + (districtOrCounty?.hashCode() ?: 0)
        result = 31 * result + (fullName?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (postalCode?.hashCode() ?: 0)
        result = 31 * result + (stateOrRegion?.hashCode() ?: 0)
        result = 31 * result + (websiteUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContactInformation

        if (addressLine1 != other.addressLine1) return false
        if (addressLine2 != other.addressLine2) return false
        if (addressLine3 != other.addressLine3) return false
        if (city != other.city) return false
        if (companyName != other.companyName) return false
        if (countryCode != other.countryCode) return false
        if (districtOrCounty != other.districtOrCounty) return false
        if (fullName != other.fullName) return false
        if (phoneNumber != other.phoneNumber) return false
        if (postalCode != other.postalCode) return false
        if (stateOrRegion != other.stateOrRegion) return false
        if (websiteUrl != other.websiteUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.account.model.ContactInformation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The first line of the primary contact address.
         */
        public var addressLine1: kotlin.String? = null
        /**
         * The second line of the primary contact address, if any.
         */
        public var addressLine2: kotlin.String? = null
        /**
         * The third line of the primary contact address, if any.
         */
        public var addressLine3: kotlin.String? = null
        /**
         * The city of the primary contact address.
         */
        public var city: kotlin.String? = null
        /**
         * The name of the company associated with the primary contact information, if any.
         */
        public var companyName: kotlin.String? = null
        /**
         * The ISO-3166 two-letter country code for the primary contact address.
         */
        public var countryCode: kotlin.String? = null
        /**
         * The district or county of the primary contact address, if any.
         */
        public var districtOrCounty: kotlin.String? = null
        /**
         * The full name of the primary contact address.
         */
        public var fullName: kotlin.String? = null
        /**
         * The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * The postal code of the primary contact address.
         */
        public var postalCode: kotlin.String? = null
        /**
         * The state or region of the primary contact address. This field is required in selected countries.
         */
        public var stateOrRegion: kotlin.String? = null
        /**
         * The URL of the website associated with the primary contact information, if any.
         */
        public var websiteUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.account.model.ContactInformation) : this() {
            this.addressLine1 = x.addressLine1
            this.addressLine2 = x.addressLine2
            this.addressLine3 = x.addressLine3
            this.city = x.city
            this.companyName = x.companyName
            this.countryCode = x.countryCode
            this.districtOrCounty = x.districtOrCounty
            this.fullName = x.fullName
            this.phoneNumber = x.phoneNumber
            this.postalCode = x.postalCode
            this.stateOrRegion = x.stateOrRegion
            this.websiteUrl = x.websiteUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.account.model.ContactInformation = ContactInformation(this)

        internal fun correctErrors(): Builder {
            if (addressLine1 == null) addressLine1 = ""
            if (city == null) city = ""
            if (countryCode == null) countryCode = ""
            if (fullName == null) fullName = ""
            if (phoneNumber == null) phoneNumber = ""
            if (postalCode == null) postalCode = ""
            return this
        }
    }
}
