// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.model



class GetAlternateContactRequest private constructor(builder: BuilderImpl) {
    /**
     * Specifies the 12 digit account ID number of the Amazon Web Services account that
     * you want to access or modify with this operation.
     * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
     * identity used to call the operation.
     * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
     * the specified account ID must be a member account in the same organization. The
     * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
     * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
     * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
     * assigned.
     * The management account can't specify its own AccountId; it must call
     * the operation in standalone context by not including the AccountId
     * parameter.
     * To call this operation on an account that is not a member of an organization, then
     * don't specify this parameter, and call the operation using an identity belonging to
     * the account whose contacts you wish to retrieve or modify.
     */
    val accountId: String? = builder.accountId
    /**
     * Specifies which alternate contact you want to retrieve.
     */
    val alternateContactType: AlternateContactType? = builder.alternateContactType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetAlternateContactRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetAlternateContactRequest(")
        append("accountId=$accountId,")
        append("alternateContactType=$alternateContactType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (alternateContactType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetAlternateContactRequest

        if (accountId != other.accountId) return false
        if (alternateContactType != other.alternateContactType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetAlternateContactRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetAlternateContactRequest
        /**
         * Specifies the 12 digit account ID number of the Amazon Web Services account that
         * you want to access or modify with this operation.
         * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
         * identity used to call the operation.
         * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
         * the specified account ID must be a member account in the same organization. The
         * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
         * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
         * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
         * assigned.
         * The management account can't specify its own AccountId; it must call
         * the operation in standalone context by not including the AccountId
         * parameter.
         * To call this operation on an account that is not a member of an organization, then
         * don't specify this parameter, and call the operation using an identity belonging to
         * the account whose contacts you wish to retrieve or modify.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * Specifies which alternate contact you want to retrieve.
         */
        fun alternateContactType(alternateContactType: AlternateContactType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the 12 digit account ID number of the Amazon Web Services account that
         * you want to access or modify with this operation.
         * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
         * identity used to call the operation.
         * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
         * the specified account ID must be a member account in the same organization. The
         * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
         * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
         * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
         * assigned.
         * The management account can't specify its own AccountId; it must call
         * the operation in standalone context by not including the AccountId
         * parameter.
         * To call this operation on an account that is not a member of an organization, then
         * don't specify this parameter, and call the operation using an identity belonging to
         * the account whose contacts you wish to retrieve or modify.
         */
        var accountId: String?
        /**
         * Specifies which alternate contact you want to retrieve.
         */
        var alternateContactType: AlternateContactType?

        fun build(): GetAlternateContactRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var alternateContactType: AlternateContactType? = null

        constructor(x: GetAlternateContactRequest) : this() {
            this.accountId = x.accountId
            this.alternateContactType = x.alternateContactType
        }

        override fun build(): GetAlternateContactRequest = GetAlternateContactRequest(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun alternateContactType(alternateContactType: AlternateContactType): FluentBuilder = apply { this.alternateContactType = alternateContactType }
    }
}
