// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.account.model



class PutAlternateContactRequest private constructor(builder: BuilderImpl) {
    /**
     * Specifies the 12 digit account ID number of the Amazon Web Services account that
     * you want to access or modify with this operation.
     * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
     * identity used to call the operation.
     * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
     * the specified account ID must be a member account in the same organization. The
     * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
     * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
     * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
     * assigned.
     * The management account can't specify its own AccountId; it must call
     * the operation in standalone context by not including the AccountId
     * parameter.
     * To call this operation on an account that is not a member of an organization, then
     * don't specify this parameter, and call the operation using an identity belonging to
     * the account whose contacts you wish to retrieve or modify.
     */
    val accountId: String? = builder.accountId
    /**
     * Specifies which alternate contact you want to create or update.
     */
    val alternateContactType: AlternateContactType? = builder.alternateContactType
    /**
     * Specifies an email address for the alternate contact.
     */
    val emailAddress: String? = builder.emailAddress
    /**
     * Specifies a name for the alternate contact.
     */
    val name: String? = builder.name
    /**
     * Specifies a phone number for the alternate contact.
     */
    val phoneNumber: String? = builder.phoneNumber
    /**
     * Specifies a title for the alternate contact.
     */
    val title: String? = builder.title

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutAlternateContactRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutAlternateContactRequest(")
        append("accountId=$accountId,")
        append("alternateContactType=$alternateContactType,")
        append("emailAddress=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("phoneNumber=*** Sensitive Data Redacted ***,")
        append("title=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (alternateContactType?.hashCode() ?: 0)
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutAlternateContactRequest

        if (accountId != other.accountId) return false
        if (alternateContactType != other.alternateContactType) return false
        if (emailAddress != other.emailAddress) return false
        if (name != other.name) return false
        if (phoneNumber != other.phoneNumber) return false
        if (title != other.title) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutAlternateContactRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutAlternateContactRequest
        /**
         * Specifies the 12 digit account ID number of the Amazon Web Services account that
         * you want to access or modify with this operation.
         * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
         * identity used to call the operation.
         * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
         * the specified account ID must be a member account in the same organization. The
         * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
         * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
         * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
         * assigned.
         * The management account can't specify its own AccountId; it must call
         * the operation in standalone context by not including the AccountId
         * parameter.
         * To call this operation on an account that is not a member of an organization, then
         * don't specify this parameter, and call the operation using an identity belonging to
         * the account whose contacts you wish to retrieve or modify.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * Specifies which alternate contact you want to create or update.
         */
        fun alternateContactType(alternateContactType: AlternateContactType): FluentBuilder
        /**
         * Specifies an email address for the alternate contact.
         */
        fun emailAddress(emailAddress: String): FluentBuilder
        /**
         * Specifies a name for the alternate contact.
         */
        fun name(name: String): FluentBuilder
        /**
         * Specifies a phone number for the alternate contact.
         */
        fun phoneNumber(phoneNumber: String): FluentBuilder
        /**
         * Specifies a title for the alternate contact.
         */
        fun title(title: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the 12 digit account ID number of the Amazon Web Services account that
         * you want to access or modify with this operation.
         * If you do not specify this parameter, it defaults to the Amazon Web Services account of the
         * identity used to call the operation.
         * To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account or a delegated administrator account, and
         * the specified account ID must be a member account in the same organization. The
         * organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
         * enabled, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access enabled for the
         * Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin account
         * assigned.
         * The management account can't specify its own AccountId; it must call
         * the operation in standalone context by not including the AccountId
         * parameter.
         * To call this operation on an account that is not a member of an organization, then
         * don't specify this parameter, and call the operation using an identity belonging to
         * the account whose contacts you wish to retrieve or modify.
         */
        var accountId: String?
        /**
         * Specifies which alternate contact you want to create or update.
         */
        var alternateContactType: AlternateContactType?
        /**
         * Specifies an email address for the alternate contact.
         */
        var emailAddress: String?
        /**
         * Specifies a name for the alternate contact.
         */
        var name: String?
        /**
         * Specifies a phone number for the alternate contact.
         */
        var phoneNumber: String?
        /**
         * Specifies a title for the alternate contact.
         */
        var title: String?

        fun build(): PutAlternateContactRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var alternateContactType: AlternateContactType? = null
        override var emailAddress: String? = null
        override var name: String? = null
        override var phoneNumber: String? = null
        override var title: String? = null

        constructor(x: PutAlternateContactRequest) : this() {
            this.accountId = x.accountId
            this.alternateContactType = x.alternateContactType
            this.emailAddress = x.emailAddress
            this.name = x.name
            this.phoneNumber = x.phoneNumber
            this.title = x.title
        }

        override fun build(): PutAlternateContactRequest = PutAlternateContactRequest(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun alternateContactType(alternateContactType: AlternateContactType): FluentBuilder = apply { this.alternateContactType = alternateContactType }
        override fun emailAddress(emailAddress: String): FluentBuilder = apply { this.emailAddress = emailAddress }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun phoneNumber(phoneNumber: String): FluentBuilder = apply { this.phoneNumber = phoneNumber }
        override fun title(title: String): FluentBuilder = apply { this.title = title }
    }
}
