// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about an ACM certificate. This structure is returned in the response to a DescribeCertificate request.
 */
public class CertificateDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The Amazon Resource Name (ARN) of the private certificate authority (CA) that issued the certificate. This has the following format:
     *
     * `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012`
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The time at which the certificate was requested.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The fully qualified domain name for the certificate, such as www.example.com or example.com.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * Contains information about the initial validation of each domain name that occurs as a result of the RequestCertificate request. This field exists only when the certificate type is `AMAZON_ISSUED`.
     */
    public val domainValidationOptions: List<DomainValidation>? = builder.domainValidationOptions
    /**
     * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID).
     */
    public val extendedKeyUsages: List<ExtendedKeyUsage>? = builder.extendedKeyUsages
    /**
     * The reason the certificate request failed. This value exists only when the certificate status is `FAILED`. For more information, see [Certificate Request Failed](https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed) in the *Certificate Manager User Guide*.
     */
    public val failureReason: aws.sdk.kotlin.services.acm.model.FailureReason? = builder.failureReason
    /**
     * The date and time when the certificate was imported. This value exists only when the certificate type is `IMPORTED`.
     */
    public val importedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.importedAt
    /**
     * A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can be used by multiple Amazon Web Services resources.
     */
    public val inUseBy: List<String>? = builder.inUseBy
    /**
     * The time at which the certificate was issued. This value exists only when the certificate type is `AMAZON_ISSUED`.
     */
    public val issuedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.issuedAt
    /**
     * The name of the certificate authority that issued and signed the certificate.
     */
    public val issuer: kotlin.String? = builder.issuer
    /**
     * The algorithm that was used to generate the public-private key pair.
     */
    public val keyAlgorithm: aws.sdk.kotlin.services.acm.model.KeyAlgorithm? = builder.keyAlgorithm
    /**
     * A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
     */
    public val keyUsages: List<KeyUsage>? = builder.keyUsages
    /**
     * The time after which the certificate is not valid.
     */
    public val notAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.notAfter
    /**
     * The time before which the certificate is not valid.
     */
    public val notBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.notBefore
    /**
     * Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure.
     */
    public val options: aws.sdk.kotlin.services.acm.model.CertificateOptions? = builder.options
    /**
     * Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the RenewCertificate command.
     */
    public val renewalEligibility: aws.sdk.kotlin.services.acm.model.RenewalEligibility? = builder.renewalEligibility
    /**
     * Contains information about the status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for the certificate. This field exists only when the certificate type is `AMAZON_ISSUED`.
     */
    public val renewalSummary: aws.sdk.kotlin.services.acm.model.RenewalSummary? = builder.renewalSummary
    /**
     * The reason the certificate was revoked. This value exists only when the certificate status is `REVOKED`.
     */
    public val revocationReason: aws.sdk.kotlin.services.acm.model.RevocationReason? = builder.revocationReason
    /**
     * The time at which the certificate was revoked. This value exists only when the certificate status is `REVOKED`.
     */
    public val revokedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.revokedAt
    /**
     * The serial number of the certificate.
     */
    public val serial: kotlin.String? = builder.serial
    /**
     * The algorithm that was used to sign the certificate.
     */
    public val signatureAlgorithm: kotlin.String? = builder.signatureAlgorithm
    /**
     * The status of the certificate.
     *
     * A certificate enters status PENDING_VALIDATION upon being requested, unless it fails for any of the reasons given in the troubleshooting topic [Certificate request fails](https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting-failed.html). ACM makes repeated attempts to validate a certificate for 72 hours and then times out. If a certificate shows status FAILED or VALIDATION_TIMED_OUT, delete the request, correct the issue with [DNS validation](https://docs.aws.amazon.com/acm/latest/userguide/dns-validation.html) or [Email validation](https://docs.aws.amazon.com/acm/latest/userguide/email-validation.html), and try again. If validation succeeds, the certificate enters status ISSUED.
     */
    public val status: aws.sdk.kotlin.services.acm.model.CertificateStatus? = builder.status
    /**
     * The name of the entity that is associated with the public key contained in the certificate.
     */
    public val subject: kotlin.String? = builder.subject
    /**
     * One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website.
     */
    public val subjectAlternativeNames: List<String>? = builder.subjectAlternativeNames
    /**
     * The source of the certificate. For certificates provided by ACM, this value is `AMAZON_ISSUED`. For certificates that you imported with ImportCertificate, this value is `IMPORTED`. ACM does not provide [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see [Importing Certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
     */
    public val type: aws.sdk.kotlin.services.acm.model.CertificateType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.CertificateDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateDetail(")
        append("certificateArn=$certificateArn,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("domainValidationOptions=$domainValidationOptions,")
        append("extendedKeyUsages=$extendedKeyUsages,")
        append("failureReason=$failureReason,")
        append("importedAt=$importedAt,")
        append("inUseBy=$inUseBy,")
        append("issuedAt=$issuedAt,")
        append("issuer=$issuer,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("keyUsages=$keyUsages,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("options=$options,")
        append("renewalEligibility=$renewalEligibility,")
        append("renewalSummary=$renewalSummary,")
        append("revocationReason=$revocationReason,")
        append("revokedAt=$revokedAt,")
        append("serial=$serial,")
        append("signatureAlgorithm=$signatureAlgorithm,")
        append("status=$status,")
        append("subject=$subject,")
        append("subjectAlternativeNames=$subjectAlternativeNames,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainValidationOptions?.hashCode() ?: 0)
        result = 31 * result + (extendedKeyUsages?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (importedAt?.hashCode() ?: 0)
        result = 31 * result + (inUseBy?.hashCode() ?: 0)
        result = 31 * result + (issuedAt?.hashCode() ?: 0)
        result = 31 * result + (issuer?.hashCode() ?: 0)
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (keyUsages?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (renewalEligibility?.hashCode() ?: 0)
        result = 31 * result + (renewalSummary?.hashCode() ?: 0)
        result = 31 * result + (revocationReason?.hashCode() ?: 0)
        result = 31 * result + (revokedAt?.hashCode() ?: 0)
        result = 31 * result + (serial?.hashCode() ?: 0)
        result = 31 * result + (signatureAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateDetail

        if (certificateArn != other.certificateArn) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (domainValidationOptions != other.domainValidationOptions) return false
        if (extendedKeyUsages != other.extendedKeyUsages) return false
        if (failureReason != other.failureReason) return false
        if (importedAt != other.importedAt) return false
        if (inUseBy != other.inUseBy) return false
        if (issuedAt != other.issuedAt) return false
        if (issuer != other.issuer) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (keyUsages != other.keyUsages) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (options != other.options) return false
        if (renewalEligibility != other.renewalEligibility) return false
        if (renewalSummary != other.renewalSummary) return false
        if (revocationReason != other.revocationReason) return false
        if (revokedAt != other.revokedAt) return false
        if (serial != other.serial) return false
        if (signatureAlgorithm != other.signatureAlgorithm) return false
        if (status != other.status) return false
        if (subject != other.subject) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.CertificateDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the private certificate authority (CA) that issued the certificate. This has the following format:
         *
         * `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012`
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * The time at which the certificate was requested.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The fully qualified domain name for the certificate, such as www.example.com or example.com.
         */
        public var domainName: kotlin.String? = null
        /**
         * Contains information about the initial validation of each domain name that occurs as a result of the RequestCertificate request. This field exists only when the certificate type is `AMAZON_ISSUED`.
         */
        public var domainValidationOptions: List<DomainValidation>? = null
        /**
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID).
         */
        public var extendedKeyUsages: List<ExtendedKeyUsage>? = null
        /**
         * The reason the certificate request failed. This value exists only when the certificate status is `FAILED`. For more information, see [Certificate Request Failed](https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed) in the *Certificate Manager User Guide*.
         */
        public var failureReason: aws.sdk.kotlin.services.acm.model.FailureReason? = null
        /**
         * The date and time when the certificate was imported. This value exists only when the certificate type is `IMPORTED`.
         */
        public var importedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can be used by multiple Amazon Web Services resources.
         */
        public var inUseBy: List<String>? = null
        /**
         * The time at which the certificate was issued. This value exists only when the certificate type is `AMAZON_ISSUED`.
         */
        public var issuedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the certificate authority that issued and signed the certificate.
         */
        public var issuer: kotlin.String? = null
        /**
         * The algorithm that was used to generate the public-private key pair.
         */
        public var keyAlgorithm: aws.sdk.kotlin.services.acm.model.KeyAlgorithm? = null
        /**
         * A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
         */
        public var keyUsages: List<KeyUsage>? = null
        /**
         * The time after which the certificate is not valid.
         */
        public var notAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time before which the certificate is not valid.
         */
        public var notBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure.
         */
        public var options: aws.sdk.kotlin.services.acm.model.CertificateOptions? = null
        /**
         * Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the RenewCertificate command.
         */
        public var renewalEligibility: aws.sdk.kotlin.services.acm.model.RenewalEligibility? = null
        /**
         * Contains information about the status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for the certificate. This field exists only when the certificate type is `AMAZON_ISSUED`.
         */
        public var renewalSummary: aws.sdk.kotlin.services.acm.model.RenewalSummary? = null
        /**
         * The reason the certificate was revoked. This value exists only when the certificate status is `REVOKED`.
         */
        public var revocationReason: aws.sdk.kotlin.services.acm.model.RevocationReason? = null
        /**
         * The time at which the certificate was revoked. This value exists only when the certificate status is `REVOKED`.
         */
        public var revokedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The serial number of the certificate.
         */
        public var serial: kotlin.String? = null
        /**
         * The algorithm that was used to sign the certificate.
         */
        public var signatureAlgorithm: kotlin.String? = null
        /**
         * The status of the certificate.
         *
         * A certificate enters status PENDING_VALIDATION upon being requested, unless it fails for any of the reasons given in the troubleshooting topic [Certificate request fails](https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting-failed.html). ACM makes repeated attempts to validate a certificate for 72 hours and then times out. If a certificate shows status FAILED or VALIDATION_TIMED_OUT, delete the request, correct the issue with [DNS validation](https://docs.aws.amazon.com/acm/latest/userguide/dns-validation.html) or [Email validation](https://docs.aws.amazon.com/acm/latest/userguide/email-validation.html), and try again. If validation succeeds, the certificate enters status ISSUED.
         */
        public var status: aws.sdk.kotlin.services.acm.model.CertificateStatus? = null
        /**
         * The name of the entity that is associated with the public key contained in the certificate.
         */
        public var subject: kotlin.String? = null
        /**
         * One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website.
         */
        public var subjectAlternativeNames: List<String>? = null
        /**
         * The source of the certificate. For certificates provided by ACM, this value is `AMAZON_ISSUED`. For certificates that you imported with ImportCertificate, this value is `IMPORTED`. ACM does not provide [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see [Importing Certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
         */
        public var type: aws.sdk.kotlin.services.acm.model.CertificateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.CertificateDetail) : this() {
            this.certificateArn = x.certificateArn
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.domainValidationOptions = x.domainValidationOptions
            this.extendedKeyUsages = x.extendedKeyUsages
            this.failureReason = x.failureReason
            this.importedAt = x.importedAt
            this.inUseBy = x.inUseBy
            this.issuedAt = x.issuedAt
            this.issuer = x.issuer
            this.keyAlgorithm = x.keyAlgorithm
            this.keyUsages = x.keyUsages
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.options = x.options
            this.renewalEligibility = x.renewalEligibility
            this.renewalSummary = x.renewalSummary
            this.revocationReason = x.revocationReason
            this.revokedAt = x.revokedAt
            this.serial = x.serial
            this.signatureAlgorithm = x.signatureAlgorithm
            this.status = x.status
            this.subject = x.subject
            this.subjectAlternativeNames = x.subjectAlternativeNames
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.CertificateDetail = CertificateDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.acm.model.CertificateOptions] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.acm.model.CertificateOptions.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.acm.model.CertificateOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acm.model.RenewalSummary] inside the given [block]
         */
        public fun renewalSummary(block: aws.sdk.kotlin.services.acm.model.RenewalSummary.Builder.() -> kotlin.Unit) {
            this.renewalSummary = aws.sdk.kotlin.services.acm.model.RenewalSummary.invoke(block)
        }
    }
}
