// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * This structure is returned in the response object of ListCertificates action.
 */
public class CertificateSummary private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the certificate. This is of the form:
     *
     * `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
     *
     * For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The time at which the certificate was requested.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * Indicates whether the certificate has been exported. This value exists only when the certificate type is `PRIVATE`.
     */
    public val exported: kotlin.Boolean? = builder.exported
    /**
     * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID).
     */
    public val extendedKeyUsages: List<ExtendedKeyUsageName>? = builder.extendedKeyUsages
    /**
     * When called by [ListCertificates](https://docs.aws.amazon.com/acm/latestAPIReference/API_ListCertificates.html), indicates whether the full list of subject alternative names has been included in the response. If false, the response includes all of the subject alternative names included in the certificate. If true, the response only includes the first 100 subject alternative names included in the certificate. To display the full list of subject alternative names, use [DescribeCertificate](https://docs.aws.amazon.com/acm/latestAPIReference/API_DescribeCertificate.html).
     */
    public val hasAdditionalSubjectAlternativeNames: kotlin.Boolean? = builder.hasAdditionalSubjectAlternativeNames
    /**
     * The date and time when the certificate was imported. This value exists only when the certificate type is `IMPORTED`.
     */
    public val importedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.importedAt
    /**
     * Indicates whether the certificate is currently in use by any Amazon Web Services resources.
     */
    public val inUse: kotlin.Boolean? = builder.inUse
    /**
     * The time at which the certificate was issued. This value exists only when the certificate type is `AMAZON_ISSUED`.
     */
    public val issuedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.issuedAt
    /**
     * The algorithm that was used to generate the public-private key pair.
     */
    public val keyAlgorithm: aws.sdk.kotlin.services.acm.model.KeyAlgorithm? = builder.keyAlgorithm
    /**
     * A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
     */
    public val keyUsages: List<KeyUsageName>? = builder.keyUsages
    /**
     * The time after which the certificate is not valid.
     */
    public val notAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.notAfter
    /**
     * The time before which the certificate is not valid.
     */
    public val notBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.notBefore
    /**
     * Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the RenewCertificate command.
     */
    public val renewalEligibility: aws.sdk.kotlin.services.acm.model.RenewalEligibility? = builder.renewalEligibility
    /**
     * The time at which the certificate was revoked. This value exists only when the certificate status is `REVOKED`.
     */
    public val revokedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.revokedAt
    /**
     * The status of the certificate.
     *
     * A certificate enters status PENDING_VALIDATION upon being requested, unless it fails for any of the reasons given in the troubleshooting topic [Certificate request fails](https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting-failed.html). ACM makes repeated attempts to validate a certificate for 72 hours and then times out. If a certificate shows status FAILED or VALIDATION_TIMED_OUT, delete the request, correct the issue with [DNS validation](https://docs.aws.amazon.com/acm/latest/userguide/dns-validation.html) or [Email validation](https://docs.aws.amazon.com/acm/latest/userguide/email-validation.html), and try again. If validation succeeds, the certificate enters status ISSUED.
     */
    public val status: aws.sdk.kotlin.services.acm.model.CertificateStatus? = builder.status
    /**
     * One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website.
     *
     * When called by [ListCertificates](https://docs.aws.amazon.com/acm/latestAPIReference/API_ListCertificates.html), this parameter will only return the first 100 subject alternative names included in the certificate. To display the full list of subject alternative names, use [DescribeCertificate](https://docs.aws.amazon.com/acm/latestAPIReference/API_DescribeCertificate.html).
     */
    public val subjectAlternativeNameSummaries: List<String>? = builder.subjectAlternativeNameSummaries
    /**
     * The source of the certificate. For certificates provided by ACM, this value is `AMAZON_ISSUED`. For certificates that you imported with ImportCertificate, this value is `IMPORTED`. ACM does not provide [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see [Importing Certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
     */
    public val type: aws.sdk.kotlin.services.acm.model.CertificateType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.CertificateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateSummary(")
        append("certificateArn=$certificateArn,")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("exported=$exported,")
        append("extendedKeyUsages=$extendedKeyUsages,")
        append("hasAdditionalSubjectAlternativeNames=$hasAdditionalSubjectAlternativeNames,")
        append("importedAt=$importedAt,")
        append("inUse=$inUse,")
        append("issuedAt=$issuedAt,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("keyUsages=$keyUsages,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("renewalEligibility=$renewalEligibility,")
        append("revokedAt=$revokedAt,")
        append("status=$status,")
        append("subjectAlternativeNameSummaries=$subjectAlternativeNameSummaries,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (exported?.hashCode() ?: 0)
        result = 31 * result + (extendedKeyUsages?.hashCode() ?: 0)
        result = 31 * result + (hasAdditionalSubjectAlternativeNames?.hashCode() ?: 0)
        result = 31 * result + (importedAt?.hashCode() ?: 0)
        result = 31 * result + (inUse?.hashCode() ?: 0)
        result = 31 * result + (issuedAt?.hashCode() ?: 0)
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (keyUsages?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (renewalEligibility?.hashCode() ?: 0)
        result = 31 * result + (revokedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNameSummaries?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateSummary

        if (certificateArn != other.certificateArn) return false
        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (exported != other.exported) return false
        if (extendedKeyUsages != other.extendedKeyUsages) return false
        if (hasAdditionalSubjectAlternativeNames != other.hasAdditionalSubjectAlternativeNames) return false
        if (importedAt != other.importedAt) return false
        if (inUse != other.inUse) return false
        if (issuedAt != other.issuedAt) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (keyUsages != other.keyUsages) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (renewalEligibility != other.renewalEligibility) return false
        if (revokedAt != other.revokedAt) return false
        if (status != other.status) return false
        if (subjectAlternativeNameSummaries != other.subjectAlternativeNameSummaries) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.CertificateSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the certificate. This is of the form:
         *
         * `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
         *
         * For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The time at which the certificate was requested.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.
         */
        public var domainName: kotlin.String? = null
        /**
         * Indicates whether the certificate has been exported. This value exists only when the certificate type is `PRIVATE`.
         */
        public var exported: kotlin.Boolean? = null
        /**
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID).
         */
        public var extendedKeyUsages: List<ExtendedKeyUsageName>? = null
        /**
         * When called by [ListCertificates](https://docs.aws.amazon.com/acm/latestAPIReference/API_ListCertificates.html), indicates whether the full list of subject alternative names has been included in the response. If false, the response includes all of the subject alternative names included in the certificate. If true, the response only includes the first 100 subject alternative names included in the certificate. To display the full list of subject alternative names, use [DescribeCertificate](https://docs.aws.amazon.com/acm/latestAPIReference/API_DescribeCertificate.html).
         */
        public var hasAdditionalSubjectAlternativeNames: kotlin.Boolean? = null
        /**
         * The date and time when the certificate was imported. This value exists only when the certificate type is `IMPORTED`.
         */
        public var importedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the certificate is currently in use by any Amazon Web Services resources.
         */
        public var inUse: kotlin.Boolean? = null
        /**
         * The time at which the certificate was issued. This value exists only when the certificate type is `AMAZON_ISSUED`.
         */
        public var issuedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The algorithm that was used to generate the public-private key pair.
         */
        public var keyAlgorithm: aws.sdk.kotlin.services.acm.model.KeyAlgorithm? = null
        /**
         * A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
         */
        public var keyUsages: List<KeyUsageName>? = null
        /**
         * The time after which the certificate is not valid.
         */
        public var notAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time before which the certificate is not valid.
         */
        public var notBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the RenewCertificate command.
         */
        public var renewalEligibility: aws.sdk.kotlin.services.acm.model.RenewalEligibility? = null
        /**
         * The time at which the certificate was revoked. This value exists only when the certificate status is `REVOKED`.
         */
        public var revokedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the certificate.
         *
         * A certificate enters status PENDING_VALIDATION upon being requested, unless it fails for any of the reasons given in the troubleshooting topic [Certificate request fails](https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting-failed.html). ACM makes repeated attempts to validate a certificate for 72 hours and then times out. If a certificate shows status FAILED or VALIDATION_TIMED_OUT, delete the request, correct the issue with [DNS validation](https://docs.aws.amazon.com/acm/latest/userguide/dns-validation.html) or [Email validation](https://docs.aws.amazon.com/acm/latest/userguide/email-validation.html), and try again. If validation succeeds, the certificate enters status ISSUED.
         */
        public var status: aws.sdk.kotlin.services.acm.model.CertificateStatus? = null
        /**
         * One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website.
         *
         * When called by [ListCertificates](https://docs.aws.amazon.com/acm/latestAPIReference/API_ListCertificates.html), this parameter will only return the first 100 subject alternative names included in the certificate. To display the full list of subject alternative names, use [DescribeCertificate](https://docs.aws.amazon.com/acm/latestAPIReference/API_DescribeCertificate.html).
         */
        public var subjectAlternativeNameSummaries: List<String>? = null
        /**
         * The source of the certificate. For certificates provided by ACM, this value is `AMAZON_ISSUED`. For certificates that you imported with ImportCertificate, this value is `IMPORTED`. ACM does not provide [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see [Importing Certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
         */
        public var type: aws.sdk.kotlin.services.acm.model.CertificateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.CertificateSummary) : this() {
            this.certificateArn = x.certificateArn
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.exported = x.exported
            this.extendedKeyUsages = x.extendedKeyUsages
            this.hasAdditionalSubjectAlternativeNames = x.hasAdditionalSubjectAlternativeNames
            this.importedAt = x.importedAt
            this.inUse = x.inUse
            this.issuedAt = x.issuedAt
            this.keyAlgorithm = x.keyAlgorithm
            this.keyUsages = x.keyUsages
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.renewalEligibility = x.renewalEligibility
            this.revokedAt = x.revokedAt
            this.status = x.status
            this.subjectAlternativeNameSummaries = x.subjectAlternativeNameSummaries
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.CertificateSummary = CertificateSummary(this)
    }
}
