// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.endpoints.internal

import aws.sdk.kotlin.runtime.endpoint.authScheme
import aws.sdk.kotlin.runtime.endpoint.setSigningContext
import aws.sdk.kotlin.services.acm.AcmClient
import aws.sdk.kotlin.services.acm.endpoints.EndpointParameters
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest
import aws.smithy.kotlin.runtime.util.get

internal class EndpointResolverAdapter(
    private val config: AcmClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = EndpointParameters {
            bindAwsBuiltins(config)
            val opName = request.context[SdkClientOption.OperationName]
            opContextBindings[opName]?.invoke(this, request)
        }
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        endpoint.authScheme?.setSigningContext(request.context)
        return endpoint
    }
}

private typealias BindOperationContextParamsFn = (EndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
)

private fun EndpointParameters.Builder.bindAwsBuiltins(config: AcmClient.Config) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}
