// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.waiters

import aws.sdk.kotlin.services.acm.AcmClient
import aws.sdk.kotlin.services.acm.model.DescribeCertificateRequest
import aws.sdk.kotlin.services.acm.model.DescribeCertificateResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


public suspend fun AcmClient.waitUntilCertificateValidated(request: DescribeCertificateRequest): Outcome<DescribeCertificateResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeCertificateRequest, DescribeCertificateResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val certificate = it.certificate
            val domainValidationOptions = certificate?.domainValidationOptions
            val domainValidationOptionsOrEmpty = domainValidationOptions?.flattenIfPossible()
            val projection = domainValidationOptionsOrEmpty?.flatMap {
                val validationStatus = it.validationStatus?.value
                listOfNotNull(validationStatus)
            }
            !projection.isNullOrEmpty() && projection.all { it == "SUCCESS" }
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val certificate = it.certificate
            val domainValidationOptions = certificate?.domainValidationOptions
            val domainValidationOptionsOrEmpty = domainValidationOptions?.flattenIfPossible()
            val projection = domainValidationOptionsOrEmpty?.flatMap {
                val validationStatus = it.validationStatus?.value
                listOfNotNull(validationStatus)
            }
            projection?.any { it == "PENDING_VALIDATION" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val certificate = it.certificate
            val status = certificate?.status?.value
            status == "FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCertificate(request) }
}

public suspend fun AcmClient.waitUntilCertificateValidated(block: DescribeCertificateRequest.Builder.() -> Unit): Outcome<DescribeCertificateResponse> =
    waitUntilCertificateValidated(DescribeCertificateRequest.Builder().apply(block).build())
