// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.transform

import aws.sdk.kotlin.services.acm.model.AcmException
import aws.sdk.kotlin.services.acm.model.RequestCertificateResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RequestCertificateOperationDeserializer: HttpDeserialize<RequestCertificateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RequestCertificateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRequestCertificateError(context, call)
        }
        val builder = RequestCertificateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRequestCertificateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRequestCertificateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AcmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidDomainValidationOptionsException" -> InvalidDomainValidationOptionsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "TagPolicyException" -> TagPolicyExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyTagsException" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AcmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRequestCertificateOperationBody(builder: RequestCertificateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CertificateArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CERTIFICATEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CERTIFICATEARN_DESCRIPTOR.index -> builder.certificateArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
