// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.acm.auth.AcmAuthSchemeProvider
import aws.sdk.kotlin.services.acm.auth.DefaultAcmAuthSchemeProvider
import aws.sdk.kotlin.services.acm.endpoints.AcmEndpointParameters
import aws.sdk.kotlin.services.acm.endpoints.AcmEndpointProvider
import aws.sdk.kotlin.services.acm.endpoints.DefaultAcmEndpointProvider
import aws.sdk.kotlin.services.acm.model.AddTagsToCertificateRequest
import aws.sdk.kotlin.services.acm.model.AddTagsToCertificateResponse
import aws.sdk.kotlin.services.acm.model.DeleteCertificateRequest
import aws.sdk.kotlin.services.acm.model.DeleteCertificateResponse
import aws.sdk.kotlin.services.acm.model.DescribeCertificateRequest
import aws.sdk.kotlin.services.acm.model.DescribeCertificateResponse
import aws.sdk.kotlin.services.acm.model.ExportCertificateRequest
import aws.sdk.kotlin.services.acm.model.ExportCertificateResponse
import aws.sdk.kotlin.services.acm.model.GetAccountConfigurationRequest
import aws.sdk.kotlin.services.acm.model.GetAccountConfigurationResponse
import aws.sdk.kotlin.services.acm.model.GetCertificateRequest
import aws.sdk.kotlin.services.acm.model.GetCertificateResponse
import aws.sdk.kotlin.services.acm.model.ImportCertificateRequest
import aws.sdk.kotlin.services.acm.model.ImportCertificateResponse
import aws.sdk.kotlin.services.acm.model.ListCertificatesRequest
import aws.sdk.kotlin.services.acm.model.ListCertificatesResponse
import aws.sdk.kotlin.services.acm.model.ListTagsForCertificateRequest
import aws.sdk.kotlin.services.acm.model.ListTagsForCertificateResponse
import aws.sdk.kotlin.services.acm.model.PutAccountConfigurationRequest
import aws.sdk.kotlin.services.acm.model.PutAccountConfigurationResponse
import aws.sdk.kotlin.services.acm.model.RemoveTagsFromCertificateRequest
import aws.sdk.kotlin.services.acm.model.RemoveTagsFromCertificateResponse
import aws.sdk.kotlin.services.acm.model.RenewCertificateRequest
import aws.sdk.kotlin.services.acm.model.RenewCertificateResponse
import aws.sdk.kotlin.services.acm.model.RequestCertificateRequest
import aws.sdk.kotlin.services.acm.model.RequestCertificateResponse
import aws.sdk.kotlin.services.acm.model.ResendValidationEmailRequest
import aws.sdk.kotlin.services.acm.model.ResendValidationEmailResponse
import aws.sdk.kotlin.services.acm.model.UpdateCertificateOptionsRequest
import aws.sdk.kotlin.services.acm.model.UpdateCertificateOptionsResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ACM"
public const val SdkVersion: String = "0.34.2-beta"

/**
 * # Certificate Manager
 * You can use Certificate Manager (ACM) to manage SSL/TLS certificates for your Amazon Web Services-based websites and applications. For more information about using ACM, see the [Certificate Manager User Guide](https://docs.aws.amazon.com/acm/latest/userguide/).
 */
public interface AcmClient : SdkClient {
    /**
     * AcmClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AcmClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Acm",
                "ACM",
                "acm",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AcmClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AcmClient = DefaultAcmClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: AcmAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAcmAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AcmEndpointProvider = builder.endpointProvider ?: DefaultAcmEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ACM"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AcmAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AcmEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds one or more tags to an ACM certificate. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a `key` and an optional `value`. You specify the certificate on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair.
     *
     * You can apply a tag to just one certificate if you want to identify a specific characteristic of that certificate, or you can apply the same tag to multiple certificates if you want to filter for a common relationship among those certificates. Similarly, you can apply the same tag to multiple resources if you want to specify a relationship among those resources. For example, you can add the same tag to an ACM certificate and an Elastic Load Balancing load balancer to indicate that they are both used by the same website. For more information, see [Tagging ACM certificates](https://docs.aws.amazon.com/acm/latest/userguide/tags.html).
     *
     * To remove one or more tags, use the RemoveTagsFromCertificate action. To view all of the tags that have been applied to the certificate, use the ListTagsForCertificate action.
     */
    public suspend fun addTagsToCertificate(input: AddTagsToCertificateRequest): AddTagsToCertificateResponse

    /**
     * Deletes a certificate and its associated private key. If this action succeeds, the certificate no longer appears in the list that can be displayed by calling the ListCertificates action or be retrieved by calling the GetCertificate action. The certificate will not be available for use by Amazon Web Services services integrated with ACM.
     *
     * You cannot delete an ACM certificate that is being used by another Amazon Web Services service. To delete a certificate that is in use, the certificate association must first be removed.
     */
    public suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse

    /**
     * Returns detailed metadata about the specified ACM certificate.
     *
     * If you have just created a certificate using the `RequestCertificate` action, there is a delay of several seconds before you can retrieve information about it.
     */
    public suspend fun describeCertificate(input: DescribeCertificateRequest): DescribeCertificateResponse

    /**
     * Exports a private certificate issued by a private certificate authority (CA) for use anywhere. The exported file contains the certificate, the certificate chain, and the encrypted private 2048-bit RSA key associated with the public key that is embedded in the certificate. For security, you must assign a passphrase for the private key when exporting it.
     *
     * For information about exporting and formatting a certificate using the ACM console or CLI, see [Export a Private Certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html).
     */
    public suspend fun exportCertificate(input: ExportCertificateRequest): ExportCertificateResponse

    /**
     * Returns the account configuration options associated with an Amazon Web Services account.
     */
    public suspend fun getAccountConfiguration(input: GetAccountConfigurationRequest = GetAccountConfigurationRequest { }): GetAccountConfigurationResponse

    /**
     * Retrieves an Amazon-issued certificate and its certificate chain. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs. All of the certificates are base64 encoded. You can use [OpenSSL](https://wiki.openssl.org/index.php/Command_Line_Utilities) to decode the certificates and inspect individual fields.
     */
    public suspend fun getCertificate(input: GetCertificateRequest): GetCertificateResponse

    /**
     * Imports a certificate into Certificate Manager (ACM) to use with services that are integrated with ACM. Note that [integrated services](https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html) allow only certificate types and keys they support to be associated with their resources. Further, their support differs depending on whether the certificate is imported into IAM or into ACM. For more information, see the documentation for each service. For more information about importing certificates into ACM, see [Importing Certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
     *
     * ACM does not provide [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for certificates that you import.
     *
     * Note the following guidelines when importing third party certificates:
     * + You must enter the private key that matches the certificate you are importing.
     * + The private key must be unencrypted. You cannot import a private key that is protected by a password or a passphrase.
     * + The private key must be no larger than 5 KB (5,120 bytes).
     * + If the certificate you are importing is not self-signed, you must enter its certificate chain.
     * + If a certificate chain is included, the issuer must be the subject of one of the certificates in the chain.
     * + The certificate, private key, and certificate chain must be PEM-encoded.
     * + The current time must be between the `Not Before` and `Not After` certificate fields.
     * + The `Issuer` field must not be empty.
     * + The OCSP authority URL, if present, must not exceed 1000 characters.
     * + To import a new certificate, omit the `CertificateArn` argument. Include this argument only when you want to replace a previously imported certificate.
     * + When you import a certificate by using the CLI, you must specify the certificate, the certificate chain, and the private key by their file names preceded by `fileb://`. For example, you can specify a certificate saved in the `C:\temp` folder as `fileb://C:\temp\certificate_to_import.pem`. If you are making an HTTP or HTTPS Query request, include these arguments as BLOBs.
     * + When you import a certificate by using an SDK, you must specify the certificate, the certificate chain, and the private key files in the manner required by the programming language you're using.
     * + The cryptographic algorithm of an imported certificate must match the algorithm of the signing CA. For example, if the signing CA key type is RSA, then the certificate key type must also be RSA.
     *
     * This operation returns the [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the imported certificate.
     */
    public suspend fun importCertificate(input: ImportCertificateRequest): ImportCertificateResponse

    /**
     * Retrieves a list of certificate ARNs and domain names. You can request that only certificates that match a specific status be listed. You can also filter by specific attributes of the certificate. Default filtering returns only `RSA_2048` certificates. For more information, see Filters.
     */
    public suspend fun listCertificates(input: ListCertificatesRequest = ListCertificatesRequest { }): ListCertificatesResponse

    /**
     * Lists the tags that have been applied to the ACM certificate. Use the certificate's Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate, use the AddTagsToCertificate action. To delete a tag, use the RemoveTagsFromCertificate action.
     */
    public suspend fun listTagsForCertificate(input: ListTagsForCertificateRequest): ListTagsForCertificateResponse

    /**
     * Adds or modifies account-level configurations in ACM.
     *
     * The supported configuration option is `DaysBeforeExpiry`. This option specifies the number of days prior to certificate expiration when ACM starts generating `EventBridge` events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.
     */
    public suspend fun putAccountConfiguration(input: PutAccountConfigurationRequest): PutAccountConfigurationResponse

    /**
     * Remove one or more tags from an ACM certificate. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this function, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value.
     *
     * To add tags to a certificate, use the AddTagsToCertificate action. To view all of the tags that have been applied to a specific ACM certificate, use the ListTagsForCertificate action.
     */
    public suspend fun removeTagsFromCertificate(input: RemoveTagsFromCertificateRequest): RemoveTagsFromCertificateResponse

    /**
     * Renews an eligible ACM certificate. At this time, only exported private certificates can be renewed with this operation. In order to renew your Amazon Web Services Private CA certificates with ACM, you must first [grant the ACM service principal permission to do so](https://docs.aws.amazon.com/privateca/latest/userguide/PcaPermissions.html). For more information, see [Testing Managed Renewal](https://docs.aws.amazon.com/acm/latest/userguide/manual-renewal.html) in the ACM User Guide.
     */
    public suspend fun renewCertificate(input: RenewCertificateRequest): RenewCertificateResponse

    /**
     * Requests an ACM certificate for use with other Amazon Web Services services. To request an ACM certificate, you must specify a fully qualified domain name (FQDN) in the `DomainName` parameter. You can also specify additional FQDNs in the `SubjectAlternativeNames` parameter.
     *
     * If you are requesting a private certificate, domain validation is not required. If you are requesting a public certificate, each domain name that you specify must be validated to verify that you own or control the domain. You can use [DNS validation](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html) or [email validation](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html). We recommend that you use DNS validation. ACM issues public certificates after receiving approval from the domain owner.
     *
     * ACM behavior differs from the [RFC 6125](https://datatracker.ietf.org/doc/html/rfc6125#appendix-B.2) specification of the certificate validation process. ACM first checks for a Subject Alternative Name, and, if it finds one, ignores the common name (CN).
     *
     * After successful completion of the `RequestCertificate` action, there is a delay of several seconds before you can retrieve information about the new certificate.
     */
    public suspend fun requestCertificate(input: RequestCertificateRequest): RequestCertificateResponse

    /**
     * Resends the email that requests domain ownership validation. The domain owner or an authorized representative must approve the ACM certificate before it can be issued. The certificate can be approved by clicking a link in the mail to navigate to the Amazon certificate approval website and then clicking **I Approve**. However, the validation email can be blocked by spam filters. Therefore, if you do not receive the original mail, you can request that the mail be resent within 72 hours of requesting the ACM certificate. If more than 72 hours have elapsed since your original request or since your last attempt to resend validation mail, you must request a new certificate. For more information about setting up your contact email addresses, see [Configure Email for your Domain](https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html).
     */
    public suspend fun resendValidationEmail(input: ResendValidationEmailRequest): ResendValidationEmailResponse

    /**
     * Updates a certificate. Currently, you can use this function to specify whether to opt in to or out of recording your certificate in a certificate transparency log. For more information, see [ Opting Out of Certificate Transparency Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency).
     */
    public suspend fun updateCertificateOptions(input: UpdateCertificateOptionsRequest): UpdateCertificateOptionsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AcmClient.withConfig(block: AcmClient.Config.Builder.() -> Unit): AcmClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAcmClient(newConfig)
}

/**
 * Adds one or more tags to an ACM certificate. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a `key` and an optional `value`. You specify the certificate on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair.
 *
 * You can apply a tag to just one certificate if you want to identify a specific characteristic of that certificate, or you can apply the same tag to multiple certificates if you want to filter for a common relationship among those certificates. Similarly, you can apply the same tag to multiple resources if you want to specify a relationship among those resources. For example, you can add the same tag to an ACM certificate and an Elastic Load Balancing load balancer to indicate that they are both used by the same website. For more information, see [Tagging ACM certificates](https://docs.aws.amazon.com/acm/latest/userguide/tags.html).
 *
 * To remove one or more tags, use the RemoveTagsFromCertificate action. To view all of the tags that have been applied to the certificate, use the ListTagsForCertificate action.
 */
public suspend inline fun AcmClient.addTagsToCertificate(crossinline block: AddTagsToCertificateRequest.Builder.() -> Unit): AddTagsToCertificateResponse = addTagsToCertificate(AddTagsToCertificateRequest.Builder().apply(block).build())

/**
 * Deletes a certificate and its associated private key. If this action succeeds, the certificate no longer appears in the list that can be displayed by calling the ListCertificates action or be retrieved by calling the GetCertificate action. The certificate will not be available for use by Amazon Web Services services integrated with ACM.
 *
 * You cannot delete an ACM certificate that is being used by another Amazon Web Services service. To delete a certificate that is in use, the certificate association must first be removed.
 */
public suspend inline fun AcmClient.deleteCertificate(crossinline block: DeleteCertificateRequest.Builder.() -> Unit): DeleteCertificateResponse = deleteCertificate(DeleteCertificateRequest.Builder().apply(block).build())

/**
 * Returns detailed metadata about the specified ACM certificate.
 *
 * If you have just created a certificate using the `RequestCertificate` action, there is a delay of several seconds before you can retrieve information about it.
 */
public suspend inline fun AcmClient.describeCertificate(crossinline block: DescribeCertificateRequest.Builder.() -> Unit): DescribeCertificateResponse = describeCertificate(DescribeCertificateRequest.Builder().apply(block).build())

/**
 * Exports a private certificate issued by a private certificate authority (CA) for use anywhere. The exported file contains the certificate, the certificate chain, and the encrypted private 2048-bit RSA key associated with the public key that is embedded in the certificate. For security, you must assign a passphrase for the private key when exporting it.
 *
 * For information about exporting and formatting a certificate using the ACM console or CLI, see [Export a Private Certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html).
 */
public suspend inline fun AcmClient.exportCertificate(crossinline block: ExportCertificateRequest.Builder.() -> Unit): ExportCertificateResponse = exportCertificate(ExportCertificateRequest.Builder().apply(block).build())

/**
 * Returns the account configuration options associated with an Amazon Web Services account.
 */
public suspend inline fun AcmClient.getAccountConfiguration(crossinline block: GetAccountConfigurationRequest.Builder.() -> Unit): GetAccountConfigurationResponse = getAccountConfiguration(GetAccountConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves an Amazon-issued certificate and its certificate chain. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs. All of the certificates are base64 encoded. You can use [OpenSSL](https://wiki.openssl.org/index.php/Command_Line_Utilities) to decode the certificates and inspect individual fields.
 */
public suspend inline fun AcmClient.getCertificate(crossinline block: GetCertificateRequest.Builder.() -> Unit): GetCertificateResponse = getCertificate(GetCertificateRequest.Builder().apply(block).build())

/**
 * Imports a certificate into Certificate Manager (ACM) to use with services that are integrated with ACM. Note that [integrated services](https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html) allow only certificate types and keys they support to be associated with their resources. Further, their support differs depending on whether the certificate is imported into IAM or into ACM. For more information, see the documentation for each service. For more information about importing certificates into ACM, see [Importing Certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
 *
 * ACM does not provide [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for certificates that you import.
 *
 * Note the following guidelines when importing third party certificates:
 * + You must enter the private key that matches the certificate you are importing.
 * + The private key must be unencrypted. You cannot import a private key that is protected by a password or a passphrase.
 * + The private key must be no larger than 5 KB (5,120 bytes).
 * + If the certificate you are importing is not self-signed, you must enter its certificate chain.
 * + If a certificate chain is included, the issuer must be the subject of one of the certificates in the chain.
 * + The certificate, private key, and certificate chain must be PEM-encoded.
 * + The current time must be between the `Not Before` and `Not After` certificate fields.
 * + The `Issuer` field must not be empty.
 * + The OCSP authority URL, if present, must not exceed 1000 characters.
 * + To import a new certificate, omit the `CertificateArn` argument. Include this argument only when you want to replace a previously imported certificate.
 * + When you import a certificate by using the CLI, you must specify the certificate, the certificate chain, and the private key by their file names preceded by `fileb://`. For example, you can specify a certificate saved in the `C:\temp` folder as `fileb://C:\temp\certificate_to_import.pem`. If you are making an HTTP or HTTPS Query request, include these arguments as BLOBs.
 * + When you import a certificate by using an SDK, you must specify the certificate, the certificate chain, and the private key files in the manner required by the programming language you're using.
 * + The cryptographic algorithm of an imported certificate must match the algorithm of the signing CA. For example, if the signing CA key type is RSA, then the certificate key type must also be RSA.
 *
 * This operation returns the [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the imported certificate.
 */
public suspend inline fun AcmClient.importCertificate(crossinline block: ImportCertificateRequest.Builder.() -> Unit): ImportCertificateResponse = importCertificate(ImportCertificateRequest.Builder().apply(block).build())

/**
 * Retrieves a list of certificate ARNs and domain names. You can request that only certificates that match a specific status be listed. You can also filter by specific attributes of the certificate. Default filtering returns only `RSA_2048` certificates. For more information, see Filters.
 */
public suspend inline fun AcmClient.listCertificates(crossinline block: ListCertificatesRequest.Builder.() -> Unit): ListCertificatesResponse = listCertificates(ListCertificatesRequest.Builder().apply(block).build())

/**
 * Lists the tags that have been applied to the ACM certificate. Use the certificate's Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate, use the AddTagsToCertificate action. To delete a tag, use the RemoveTagsFromCertificate action.
 */
public suspend inline fun AcmClient.listTagsForCertificate(crossinline block: ListTagsForCertificateRequest.Builder.() -> Unit): ListTagsForCertificateResponse = listTagsForCertificate(ListTagsForCertificateRequest.Builder().apply(block).build())

/**
 * Adds or modifies account-level configurations in ACM.
 *
 * The supported configuration option is `DaysBeforeExpiry`. This option specifies the number of days prior to certificate expiration when ACM starts generating `EventBridge` events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.
 */
public suspend inline fun AcmClient.putAccountConfiguration(crossinline block: PutAccountConfigurationRequest.Builder.() -> Unit): PutAccountConfigurationResponse = putAccountConfiguration(PutAccountConfigurationRequest.Builder().apply(block).build())

/**
 * Remove one or more tags from an ACM certificate. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this function, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value.
 *
 * To add tags to a certificate, use the AddTagsToCertificate action. To view all of the tags that have been applied to a specific ACM certificate, use the ListTagsForCertificate action.
 */
public suspend inline fun AcmClient.removeTagsFromCertificate(crossinline block: RemoveTagsFromCertificateRequest.Builder.() -> Unit): RemoveTagsFromCertificateResponse = removeTagsFromCertificate(RemoveTagsFromCertificateRequest.Builder().apply(block).build())

/**
 * Renews an eligible ACM certificate. At this time, only exported private certificates can be renewed with this operation. In order to renew your Amazon Web Services Private CA certificates with ACM, you must first [grant the ACM service principal permission to do so](https://docs.aws.amazon.com/privateca/latest/userguide/PcaPermissions.html). For more information, see [Testing Managed Renewal](https://docs.aws.amazon.com/acm/latest/userguide/manual-renewal.html) in the ACM User Guide.
 */
public suspend inline fun AcmClient.renewCertificate(crossinline block: RenewCertificateRequest.Builder.() -> Unit): RenewCertificateResponse = renewCertificate(RenewCertificateRequest.Builder().apply(block).build())

/**
 * Requests an ACM certificate for use with other Amazon Web Services services. To request an ACM certificate, you must specify a fully qualified domain name (FQDN) in the `DomainName` parameter. You can also specify additional FQDNs in the `SubjectAlternativeNames` parameter.
 *
 * If you are requesting a private certificate, domain validation is not required. If you are requesting a public certificate, each domain name that you specify must be validated to verify that you own or control the domain. You can use [DNS validation](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html) or [email validation](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html). We recommend that you use DNS validation. ACM issues public certificates after receiving approval from the domain owner.
 *
 * ACM behavior differs from the [RFC 6125](https://datatracker.ietf.org/doc/html/rfc6125#appendix-B.2) specification of the certificate validation process. ACM first checks for a Subject Alternative Name, and, if it finds one, ignores the common name (CN).
 *
 * After successful completion of the `RequestCertificate` action, there is a delay of several seconds before you can retrieve information about the new certificate.
 */
public suspend inline fun AcmClient.requestCertificate(crossinline block: RequestCertificateRequest.Builder.() -> Unit): RequestCertificateResponse = requestCertificate(RequestCertificateRequest.Builder().apply(block).build())

/**
 * Resends the email that requests domain ownership validation. The domain owner or an authorized representative must approve the ACM certificate before it can be issued. The certificate can be approved by clicking a link in the mail to navigate to the Amazon certificate approval website and then clicking **I Approve**. However, the validation email can be blocked by spam filters. Therefore, if you do not receive the original mail, you can request that the mail be resent within 72 hours of requesting the ACM certificate. If more than 72 hours have elapsed since your original request or since your last attempt to resend validation mail, you must request a new certificate. For more information about setting up your contact email addresses, see [Configure Email for your Domain](https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html).
 */
public suspend inline fun AcmClient.resendValidationEmail(crossinline block: ResendValidationEmailRequest.Builder.() -> Unit): ResendValidationEmailResponse = resendValidationEmail(ResendValidationEmailRequest.Builder().apply(block).build())

/**
 * Updates a certificate. Currently, you can use this function to specify whether to opt in to or out of recording your certificate in a certificate transparency log. For more information, see [ Opting Out of Certificate Transparency Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency).
 */
public suspend inline fun AcmClient.updateCertificateOptions(crossinline block: UpdateCertificateOptionsRequest.Builder.() -> Unit): UpdateCertificateOptionsResponse = updateCertificateOptions(UpdateCertificateOptionsRequest.Builder().apply(block).build())
