// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.endpoints.internal

import aws.sdk.kotlin.services.acm.AcmClient
import aws.sdk.kotlin.services.acm.endpoints.AcmEndpointParameters
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest
import aws.smithy.kotlin.runtime.util.get

internal class EndpointResolverAdapter(
    private val config: AcmClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: AcmClient.Config, request: ResolveEndpointRequest): AcmEndpointParameters {
    return AcmEndpointParameters {
        bindAwsBuiltins(config)
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (AcmEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
)

private fun AcmEndpointParameters.Builder.bindAwsBuiltins(config: AcmClient.Config) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}
