// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the domain names that you want ACM to use to send you emails that enable you to validate domain ownership.
 */
public class DomainValidationOption private constructor(builder: Builder) {
    /**
     * A fully qualified domain name (FQDN) in the certificate request.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * The domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `DomainName` value or a superdomain of the `DomainName` value. For example, if you request a certificate for `testing.example.com`, you can specify `example.com` for this value. In that case, ACM sends domain validation emails to the following five addresses:
     * + admin@example.com
     * + administrator@example.com
     * + hostmaster@example.com
     * + postmaster@example.com
     * + webmaster@example.com
     */
    public val validationDomain: kotlin.String = requireNotNull(builder.validationDomain) { "A non-null value must be provided for validationDomain" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.DomainValidationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainValidationOption(")
        append("domainName=$domainName,")
        append("validationDomain=$validationDomain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName.hashCode()
        result = 31 * result + (validationDomain.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainValidationOption

        if (domainName != other.domainName) return false
        if (validationDomain != other.validationDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.DomainValidationOption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A fully qualified domain name (FQDN) in the certificate request.
         */
        public var domainName: kotlin.String? = null
        /**
         * The domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `DomainName` value or a superdomain of the `DomainName` value. For example, if you request a certificate for `testing.example.com`, you can specify `example.com` for this value. In that case, ACM sends domain validation emails to the following five addresses:
         * + admin@example.com
         * + administrator@example.com
         * + hostmaster@example.com
         * + postmaster@example.com
         * + webmaster@example.com
         */
        public var validationDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.DomainValidationOption) : this() {
            this.domainName = x.domainName
            this.validationDomain = x.validationDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.DomainValidationOption = DomainValidationOption(this)

        internal fun correctErrors(): Builder {
            if (domainName == null) domainName = ""
            if (validationDomain == null) validationDomain = ""
            return this
        }
    }
}
