// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



/**
 * Contains information about the validation of each domain name in the certificate.
 */
class DomainValidation private constructor(builder: Builder) {
    /**
     * A fully qualified domain name (FQDN) in the certificate. For example,
     * www.example.com or example.com.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * Contains the CNAME record that you add to your DNS database for domain validation. For
     * more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership.
     * Note: The CNAME information that you need does not include the name of your domain. If you
     * include  your domain name in the DNS database CNAME record, validation fails.  For example, if
     * the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only
     * "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.
     */
    val resourceRecord: aws.sdk.kotlin.services.acm.model.ResourceRecord? = builder.resourceRecord
    /**
     * The domain name that ACM used to send domain validation emails.
     */
    val validationDomain: kotlin.String? = builder.validationDomain
    /**
     * A list of email addresses that ACM used to send domain validation emails.
     */
    val validationEmails: List<String>? = builder.validationEmails
    /**
     * Specifies the domain validation method.
     */
    val validationMethod: aws.sdk.kotlin.services.acm.model.ValidationMethod? = builder.validationMethod
    /**
     * The validation status of the domain name. This can be one of the following values:
     * PENDING_VALIDATION
     * SUCCESS
     * FAILED
     */
    val validationStatus: aws.sdk.kotlin.services.acm.model.DomainStatus? = builder.validationStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.DomainValidation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainValidation(")
        append("domainName=$domainName,")
        append("resourceRecord=$resourceRecord,")
        append("validationDomain=$validationDomain,")
        append("validationEmails=$validationEmails,")
        append("validationMethod=$validationMethod,")
        append("validationStatus=$validationStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (resourceRecord?.hashCode() ?: 0)
        result = 31 * result + (validationDomain?.hashCode() ?: 0)
        result = 31 * result + (validationEmails?.hashCode() ?: 0)
        result = 31 * result + (validationMethod?.hashCode() ?: 0)
        result = 31 * result + (validationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainValidation

        if (domainName != other.domainName) return false
        if (resourceRecord != other.resourceRecord) return false
        if (validationDomain != other.validationDomain) return false
        if (validationEmails != other.validationEmails) return false
        if (validationMethod != other.validationMethod) return false
        if (validationStatus != other.validationStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.DomainValidation = Builder(this).apply(block).build()

    class Builder {
        /**
         * A fully qualified domain name (FQDN) in the certificate. For example,
         * www.example.com or example.com.
         */
        var domainName: kotlin.String? = null
        /**
         * Contains the CNAME record that you add to your DNS database for domain validation. For
         * more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership.
         * Note: The CNAME information that you need does not include the name of your domain. If you
         * include  your domain name in the DNS database CNAME record, validation fails.  For example, if
         * the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only
         * "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.
         */
        var resourceRecord: aws.sdk.kotlin.services.acm.model.ResourceRecord? = null
        /**
         * The domain name that ACM used to send domain validation emails.
         */
        var validationDomain: kotlin.String? = null
        /**
         * A list of email addresses that ACM used to send domain validation emails.
         */
        var validationEmails: List<String>? = null
        /**
         * Specifies the domain validation method.
         */
        var validationMethod: aws.sdk.kotlin.services.acm.model.ValidationMethod? = null
        /**
         * The validation status of the domain name. This can be one of the following values:
         * PENDING_VALIDATION
         * SUCCESS
         * FAILED
         */
        var validationStatus: aws.sdk.kotlin.services.acm.model.DomainStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.DomainValidation) : this() {
            this.domainName = x.domainName
            this.resourceRecord = x.resourceRecord
            this.validationDomain = x.validationDomain
            this.validationEmails = x.validationEmails
            this.validationMethod = x.validationMethod
            this.validationStatus = x.validationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.DomainValidation = DomainValidation(this)

        /**
         * construct an [aws.sdk.kotlin.services.acm.model.ResourceRecord] inside the given [block]
         */
        fun resourceRecord(block: aws.sdk.kotlin.services.acm.model.ResourceRecord.Builder.() -> kotlin.Unit) {
            this.resourceRecord = aws.sdk.kotlin.services.acm.model.ResourceRecord.invoke(block)
        }
    }
}
