// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.paginators

import aws.sdk.kotlin.services.acm.AcmClient
import aws.sdk.kotlin.services.acm.model.CertificateSummary
import aws.sdk.kotlin.services.acm.model.ListCertificatesRequest
import aws.sdk.kotlin.services.acm.model.ListCertificatesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCertificatesResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCertificatesResponse]
 */
fun AcmClient.listCertificatesPaginated(initialRequest: ListCertificatesRequest): Flow<ListCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCertificatesPaginated.listCertificates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listCertificatesPaginated]
 * to access the nested member [CertificateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CertificateSummary]
 */
@JvmName("listCertificatesResponseCertificateSummary")
fun Flow<ListCertificatesResponse>.certificateSummaryList(): Flow<CertificateSummary> =
    transform() { response ->
        response.certificateSummaryList?.forEach {
            emit(it)
        }
    }
