// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.waiters

import aws.sdk.kotlin.services.acm.AcmClient
import aws.sdk.kotlin.services.acm.model.DescribeCertificateRequest
import aws.sdk.kotlin.services.acm.model.DescribeCertificateResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.util.flattenIfPossible


suspend fun AcmClient.waitUntilCertificateValidated(request: DescribeCertificateRequest): Outcome<DescribeCertificateResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelayMs = 60_000,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoffMs = 120_000,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxTimeMs = 300_000, maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeCertificateRequest, DescribeCertificateResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val certificate = it?.certificate
            val domainValidationOptions = certificate?.domainValidationOptions
            val domainValidationOptionsOrEmpty = domainValidationOptions?.flattenIfPossible() ?: listOf()
            val projection = domainValidationOptionsOrEmpty.flatMap {
                val validationStatus = it?.validationStatus
                listOfNotNull(validationStatus)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "SUCCESS" }
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val certificate = it?.certificate
            val domainValidationOptions = certificate?.domainValidationOptions
            val domainValidationOptionsOrEmpty = domainValidationOptions?.flattenIfPossible() ?: listOf()
            val projection = domainValidationOptionsOrEmpty.flatMap {
                val validationStatus = it?.validationStatus
                listOfNotNull(validationStatus)
            }
            projection?.any { it?.toString() == "PENDING_VALIDATION" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val certificate = it?.certificate
            val status = certificate?.status
            status?.toString() == "FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCertificate(request) }
}

suspend fun AcmClient.waitUntilCertificateValidated(block: DescribeCertificateRequest.Builder.() -> Unit): Outcome<DescribeCertificateResponse> =
    waitUntilCertificateValidated(DescribeCertificateRequest.Builder().apply(block).build())
