// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



/**
 * This structure is returned in the response object of ListCertificates action.
 */
public class CertificateSummary private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the certificate. This is of the form:
     *
     * `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
     *
     * For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.
     */
    public val domainName: kotlin.String? = builder.domainName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.CertificateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateSummary(")
        append("certificateArn=$certificateArn,")
        append("domainName=$domainName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateSummary

        if (certificateArn != other.certificateArn) return false
        if (domainName != other.domainName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.CertificateSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the certificate. This is of the form:
         *
         * `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
         *
         * For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var certificateArn: kotlin.String? = null
        /**
         * Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.
         */
        public var domainName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.CertificateSummary) : this() {
            this.certificateArn = x.certificateArn
            this.domainName = x.domainName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.CertificateSummary = CertificateSummary(this)
    }
}
