// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.endpoints

import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region ap-south-2 with FIPS enabled and DualStack enabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-south-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-south-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-2 with FIPS enabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-south-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-south-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-2 with FIPS disabled and DualStack enabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-south-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-south-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-2 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-south-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-south-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-south-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-south-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-south-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-south-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-south-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-south-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-south-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-south-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-2 with FIPS enabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-south-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-south-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-2 with FIPS enabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-south-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-south-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-2 with FIPS disabled and DualStack enabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-south-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-south-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-2 with FIPS disabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-south-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-south-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-gov-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-gov-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-gov-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-gov-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-gov-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-gov-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-gov-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-gov-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "me-central-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.me-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "me-central-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.me-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "me-central-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.me-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "me-central-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.me-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ca-central-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ca-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test25() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ca-central-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ca-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test26() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ca-central-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ca-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test27() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ca-central-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ca-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test28() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-central-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test29() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-central-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test30() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-central-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test31() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-central-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test32() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-iso-west-1"
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-iso-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test33() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-iso-west-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-iso-west-1.c2s.ic.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test34() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-iso-west-1"
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-iso-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test35() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-iso-west-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-iso-west-1.c2s.ic.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-2 with FIPS enabled and DualStack enabled
    @Test
    fun test36() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-central-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-central-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-2 with FIPS enabled and DualStack disabled
    @Test
    fun test37() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-central-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-central-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-2 with FIPS disabled and DualStack enabled
    @Test
    fun test38() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-central-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-central-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-2 with FIPS disabled and DualStack disabled
    @Test
    fun test39() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-central-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-central-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test40() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-west-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test41() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-west-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test42() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-west-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test43() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-west-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test44() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-west-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test45() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-west-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test46() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-west-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test47() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-west-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test48() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "af-south-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.af-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test49() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "af-south-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.af-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test50() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "af-south-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.af-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test51() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "af-south-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.af-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test52() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-north-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-north-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test53() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-north-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-north-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test54() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-north-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-north-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test55() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-north-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-north-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS enabled and DualStack enabled
    @Test
    fun test56() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-west-3"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-west-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS enabled and DualStack disabled
    @Test
    fun test57() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-west-3"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-west-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS disabled and DualStack enabled
    @Test
    fun test58() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-west-3"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-west-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS disabled and DualStack disabled
    @Test
    fun test59() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-west-3"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-west-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test60() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-west-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test61() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-west-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test62() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-west-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test63() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-west-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test64() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-west-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test65() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "eu-west-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test66() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-west-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test67() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "eu-west-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS enabled and DualStack enabled
    @Test
    fun test68() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-northeast-3"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-northeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS enabled and DualStack disabled
    @Test
    fun test69() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-northeast-3"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-northeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS disabled and DualStack enabled
    @Test
    fun test70() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-northeast-3"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-northeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS disabled and DualStack disabled
    @Test
    fun test71() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-northeast-3"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-northeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test72() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-northeast-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-northeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test73() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-northeast-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-northeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test74() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-northeast-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-northeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test75() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-northeast-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-northeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test76() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-northeast-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test77() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-northeast-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test78() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-northeast-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test79() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-northeast-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test80() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "me-south-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.me-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test81() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "me-south-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.me-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test82() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "me-south-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.me-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test83() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "me-south-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.me-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test84() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "sa-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.sa-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test85() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "sa-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.sa-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test86() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "sa-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.sa-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test87() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "sa-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.sa-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test88() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test89() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test90() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test91() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test92() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "cn-north-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.cn-north-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test93() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "cn-north-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.cn-north-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test94() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "cn-north-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.cn-north-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test95() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "cn-north-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.cn-north-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test96() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-gov-west-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-gov-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test97() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-gov-west-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-gov-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test98() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-gov-west-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-gov-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test99() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-gov-west-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-gov-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test100() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-southeast-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test101() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-southeast-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test102() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-southeast-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test103() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-southeast-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test104() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-southeast-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test105() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-southeast-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test106() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-southeast-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test107() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-southeast-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test108() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-iso-east-1"
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test109() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-iso-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-iso-east-1.c2s.ic.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test110() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-iso-east-1"
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test111() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-iso-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-iso-east-1.c2s.ic.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-3 with FIPS enabled and DualStack enabled
    @Test
    fun test112() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-southeast-3"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-southeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-3 with FIPS enabled and DualStack disabled
    @Test
    fun test113() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-southeast-3"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-southeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-3 with FIPS disabled and DualStack enabled
    @Test
    fun test114() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-southeast-3"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-southeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-3 with FIPS disabled and DualStack disabled
    @Test
    fun test115() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-southeast-3"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-southeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-4 with FIPS enabled and DualStack enabled
    @Test
    fun test116() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-southeast-4"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-southeast-4.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-4 with FIPS enabled and DualStack disabled
    @Test
    fun test117() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "ap-southeast-4"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.ap-southeast-4.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-4 with FIPS disabled and DualStack enabled
    @Test
    fun test118() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-southeast-4"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-southeast-4.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-4 with FIPS disabled and DualStack disabled
    @Test
    fun test119() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "ap-southeast-4"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.ap-southeast-4.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test120() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test121() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test122() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-east-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test123() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS enabled and DualStack enabled
    @Test
    fun test124() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-east-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-east-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS enabled and DualStack disabled
    @Test
    fun test125() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-east-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-east-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack enabled
    @Test
    fun test126() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-east-2"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-east-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack disabled
    @Test
    fun test127() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-east-2"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-east-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-northwest-1 with FIPS enabled and DualStack enabled
    @Test
    fun test128() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "cn-northwest-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.cn-northwest-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-northwest-1 with FIPS enabled and DualStack disabled
    @Test
    fun test129() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "cn-northwest-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.cn-northwest-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-northwest-1 with FIPS disabled and DualStack enabled
    @Test
    fun test130() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "cn-northwest-1"
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.cn-northwest-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-northwest-1 with FIPS disabled and DualStack disabled
    @Test
    fun test131() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "cn-northwest-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.cn-northwest-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test132() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-isob-east-1"
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test133() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-isob-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm-fips.us-isob-east-1.sc2s.sgov.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test134() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-isob-east-1"
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test135() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-isob-east-1"
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://acm.us-isob-east-1.sc2s.sgov.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips disabled and dualstack disabled
    @Test
    fun test136() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-east-1"
            useDualStack = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test137() = runTest {
        val params = EndpointParameters {
            useFips = true
            region = "us-east-1"
            useDualStack = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test138() = runTest {
        val params = EndpointParameters {
            useFips = false
            region = "us-east-1"
            useDualStack = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
