// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.acm.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon Web Services Certificate Manager</fullname>
 * You can use Amazon Web Services Certificate Manager (ACM) to manage SSL/TLS certificates for your Amazon Web Services-based websites
 * and applications. For more information about using ACM, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Amazon Web Services Certificate Manager User Guide.
 */
interface AcmClient : SdkClient {

    override val serviceName: String
        get() = "ACM"
    /**
     * AcmClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): AcmClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultAcmClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Adds one or more tags to an ACM certificate. Tags are labels that you can use to
     * identify and organize your Amazon Web Services resources. Each tag consists of a key and an
     * optional value. You specify the certificate on input by its Amazon Resource Name
     * (ARN). You specify the tag by using a key-value pair.
     * You can apply a tag to just one certificate if you want to identify a specific
     * characteristic of that certificate, or you can apply the same tag to multiple certificates if
     * you want to filter for a common relationship among those certificates. Similarly, you can
     * apply the same tag to multiple resources if you want to specify a relationship among those
     * resources. For example, you can add the same tag to an ACM certificate and an Elastic Load
     * Balancing load balancer to indicate that they are both used by the same website. For more
     * information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/tags.html">Tagging ACM
     * certificates.
     * To remove one or more tags, use the RemoveTagsFromCertificate action. To
     * view all of the tags that have been applied to the certificate, use the ListTagsForCertificate action.
     */
    suspend fun addTagsToCertificate(input: AddTagsToCertificateRequest): AddTagsToCertificateResponse

    /**
     * Adds one or more tags to an ACM certificate. Tags are labels that you can use to
     * identify and organize your Amazon Web Services resources. Each tag consists of a key and an
     * optional value. You specify the certificate on input by its Amazon Resource Name
     * (ARN). You specify the tag by using a key-value pair.
     * You can apply a tag to just one certificate if you want to identify a specific
     * characteristic of that certificate, or you can apply the same tag to multiple certificates if
     * you want to filter for a common relationship among those certificates. Similarly, you can
     * apply the same tag to multiple resources if you want to specify a relationship among those
     * resources. For example, you can add the same tag to an ACM certificate and an Elastic Load
     * Balancing load balancer to indicate that they are both used by the same website. For more
     * information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/tags.html">Tagging ACM
     * certificates.
     * To remove one or more tags, use the RemoveTagsFromCertificate action. To
     * view all of the tags that have been applied to the certificate, use the ListTagsForCertificate action.
     */
    suspend fun addTagsToCertificate(block: AddTagsToCertificateRequest.DslBuilder.() -> Unit) = addTagsToCertificate(AddTagsToCertificateRequest.builder().apply(block).build())

    /**
     * Deletes a certificate and its associated private key. If this action succeeds, the
     * certificate no longer appears in the list that can be displayed by calling the ListCertificates action or be retrieved by calling the GetCertificate action. The certificate will not be available for use by Amazon Web Services
     * services integrated with ACM.
     * You cannot delete an ACM certificate that is being used by another Amazon Web Services service. To
     * delete a certificate that is in use, the certificate association must first be
     * removed.
     */
    suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse

    /**
     * Deletes a certificate and its associated private key. If this action succeeds, the
     * certificate no longer appears in the list that can be displayed by calling the ListCertificates action or be retrieved by calling the GetCertificate action. The certificate will not be available for use by Amazon Web Services
     * services integrated with ACM.
     * You cannot delete an ACM certificate that is being used by another Amazon Web Services service. To
     * delete a certificate that is in use, the certificate association must first be
     * removed.
     */
    suspend fun deleteCertificate(block: DeleteCertificateRequest.DslBuilder.() -> Unit) = deleteCertificate(DeleteCertificateRequest.builder().apply(block).build())

    /**
     * Returns detailed metadata about the specified ACM certificate.
     */
    suspend fun describeCertificate(input: DescribeCertificateRequest): DescribeCertificateResponse

    /**
     * Returns detailed metadata about the specified ACM certificate.
     */
    suspend fun describeCertificate(block: DescribeCertificateRequest.DslBuilder.() -> Unit) = describeCertificate(DescribeCertificateRequest.builder().apply(block).build())

    /**
     * Exports a private certificate issued by a private certificate authority (CA) for use
     * anywhere. The exported file contains the certificate, the certificate chain, and the encrypted
     * private 2048-bit RSA key associated with the public key that is embedded in the certificate.
     * For security, you must assign a passphrase for the private key when exporting it.
     * For information about exporting and formatting a certificate using the ACM console or
     * CLI, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html">Export a
     * Private Certificate.
     */
    suspend fun exportCertificate(input: ExportCertificateRequest): ExportCertificateResponse

    /**
     * Exports a private certificate issued by a private certificate authority (CA) for use
     * anywhere. The exported file contains the certificate, the certificate chain, and the encrypted
     * private 2048-bit RSA key associated with the public key that is embedded in the certificate.
     * For security, you must assign a passphrase for the private key when exporting it.
     * For information about exporting and formatting a certificate using the ACM console or
     * CLI, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html">Export a
     * Private Certificate.
     */
    suspend fun exportCertificate(block: ExportCertificateRequest.DslBuilder.() -> Unit) = exportCertificate(ExportCertificateRequest.builder().apply(block).build())

    /**
     * Returns the account
     * configuration options associated with an Amazon Web Services account.
     */
    suspend fun getAccountConfiguration(input: GetAccountConfigurationRequest): GetAccountConfigurationResponse

    /**
     * Returns the account
     * configuration options associated with an Amazon Web Services account.
     */
    suspend fun getAccountConfiguration(block: GetAccountConfigurationRequest.DslBuilder.() -> Unit) = getAccountConfiguration(GetAccountConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves an Amazon-issued certificate and its certificate chain. The chain consists of
     * the certificate of the issuing CA and the intermediate certificates of any other subordinate
     * CAs. All of the certificates are base64 encoded. You can use <a href="https://wiki.openssl.org/index.php/Command_Line_Utilities">OpenSSL to decode
     * the certificates and inspect individual fields.
     */
    suspend fun getCertificate(input: GetCertificateRequest): GetCertificateResponse

    /**
     * Retrieves an Amazon-issued certificate and its certificate chain. The chain consists of
     * the certificate of the issuing CA and the intermediate certificates of any other subordinate
     * CAs. All of the certificates are base64 encoded. You can use <a href="https://wiki.openssl.org/index.php/Command_Line_Utilities">OpenSSL to decode
     * the certificates and inspect individual fields.
     */
    suspend fun getCertificate(block: GetCertificateRequest.DslBuilder.() -> Unit) = getCertificate(GetCertificateRequest.builder().apply(block).build())

    /**
     * Imports a certificate into Amazon Web Services Certificate Manager (ACM) to use with services that are integrated with
     * ACM. Note that <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html">integrated
     * services allow only certificate types and keys they support to be associated with
     * their resources. Further, their support differs depending on whether the certificate is
     * imported into IAM or into ACM. For more information, see the documentation for each
     * service. For more information about importing certificates into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing
     * Certificates in the Amazon Web Services Certificate Manager User Guide.
     * ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for certificates that you import.
     * Note the following guidelines when importing third party certificates:
     * You must enter the private key that matches the certificate you are importing.
     * The private key must be unencrypted. You cannot import a private key that is protected
     * by a password or a passphrase.
     * The private key must be no larger than 5 KB (5,120 bytes).
     * If the certificate you are importing is not self-signed, you must enter its
     * certificate chain.
     * If a certificate chain is included, the issuer must be the subject of one of the
     * certificates in the chain.
     * The certificate, private key, and certificate chain must be PEM-encoded.
     * The current time must be between the Not Before and Not
     * After certificate fields.
     * The Issuer field must not be empty.
     * The OCSP authority URL, if present, must not exceed 1000 characters.
     * To import a new certificate, omit the CertificateArn argument. Include
     * this argument only when you want to replace a previously imported certificate.
     * When you import a certificate by using the CLI, you must specify the certificate, the
     * certificate chain, and the private key by their file names preceded by
     * fileb://. For example, you can specify a certificate saved in the
     * C:\temp folder as fileb://C:\temp\certificate_to_import.pem.
     * If you are making an HTTP or HTTPS Query request, include these arguments as BLOBs.
     * When you import a certificate by using an SDK, you must specify the certificate, the
     * certificate chain, and the private key files in the manner required by the programming
     * language you're using.
     * The cryptographic algorithm of an imported certificate must match the algorithm of the
     * signing CA. For example, if the signing CA key type is RSA, then the certificate key type
     * must also be RSA.
     * This operation returns the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Name (ARN) of the imported certificate.
     */
    suspend fun importCertificate(input: ImportCertificateRequest): ImportCertificateResponse

    /**
     * Imports a certificate into Amazon Web Services Certificate Manager (ACM) to use with services that are integrated with
     * ACM. Note that <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html">integrated
     * services allow only certificate types and keys they support to be associated with
     * their resources. Further, their support differs depending on whether the certificate is
     * imported into IAM or into ACM. For more information, see the documentation for each
     * service. For more information about importing certificates into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing
     * Certificates in the Amazon Web Services Certificate Manager User Guide.
     * ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for certificates that you import.
     * Note the following guidelines when importing third party certificates:
     * You must enter the private key that matches the certificate you are importing.
     * The private key must be unencrypted. You cannot import a private key that is protected
     * by a password or a passphrase.
     * The private key must be no larger than 5 KB (5,120 bytes).
     * If the certificate you are importing is not self-signed, you must enter its
     * certificate chain.
     * If a certificate chain is included, the issuer must be the subject of one of the
     * certificates in the chain.
     * The certificate, private key, and certificate chain must be PEM-encoded.
     * The current time must be between the Not Before and Not
     * After certificate fields.
     * The Issuer field must not be empty.
     * The OCSP authority URL, if present, must not exceed 1000 characters.
     * To import a new certificate, omit the CertificateArn argument. Include
     * this argument only when you want to replace a previously imported certificate.
     * When you import a certificate by using the CLI, you must specify the certificate, the
     * certificate chain, and the private key by their file names preceded by
     * fileb://. For example, you can specify a certificate saved in the
     * C:\temp folder as fileb://C:\temp\certificate_to_import.pem.
     * If you are making an HTTP or HTTPS Query request, include these arguments as BLOBs.
     * When you import a certificate by using an SDK, you must specify the certificate, the
     * certificate chain, and the private key files in the manner required by the programming
     * language you're using.
     * The cryptographic algorithm of an imported certificate must match the algorithm of the
     * signing CA. For example, if the signing CA key type is RSA, then the certificate key type
     * must also be RSA.
     * This operation returns the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Name (ARN) of the imported certificate.
     */
    suspend fun importCertificate(block: ImportCertificateRequest.DslBuilder.() -> Unit) = importCertificate(ImportCertificateRequest.builder().apply(block).build())

    /**
     * Retrieves a list of certificate ARNs and domain names. You can request that only
     * certificates that match a specific status be listed. You can also filter by specific
     * attributes of the certificate. Default filtering returns only RSA_2048
     * certificates. For more information, see Filters.
     */
    suspend fun listCertificates(input: ListCertificatesRequest): ListCertificatesResponse

    /**
     * Retrieves a list of certificate ARNs and domain names. You can request that only
     * certificates that match a specific status be listed. You can also filter by specific
     * attributes of the certificate. Default filtering returns only RSA_2048
     * certificates. For more information, see Filters.
     */
    suspend fun listCertificates(block: ListCertificatesRequest.DslBuilder.() -> Unit) = listCertificates(ListCertificatesRequest.builder().apply(block).build())

    /**
     * Lists the tags that have been applied to the ACM certificate. Use the certificate's
     * Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate,
     * use the AddTagsToCertificate action. To delete a tag, use the RemoveTagsFromCertificate action.
     */
    suspend fun listTagsForCertificate(input: ListTagsForCertificateRequest): ListTagsForCertificateResponse

    /**
     * Lists the tags that have been applied to the ACM certificate. Use the certificate's
     * Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate,
     * use the AddTagsToCertificate action. To delete a tag, use the RemoveTagsFromCertificate action.
     */
    suspend fun listTagsForCertificate(block: ListTagsForCertificateRequest.DslBuilder.() -> Unit) = listTagsForCertificate(ListTagsForCertificateRequest.builder().apply(block).build())

    /**
     * Adds or modifies
     * account-level configurations in ACM.
     * The
     * supported configuration option is DaysBeforeExpiry. This option specifies the
     * number of days prior to certificate expiration when ACM starts generating
     * EventBridge events. ACM sends one event per day per certificate until the
     * certificate expires. By default, accounts receive events starting 45 days before certificate
     * expiration.
     */
    suspend fun putAccountConfiguration(input: PutAccountConfigurationRequest): PutAccountConfigurationResponse

    /**
     * Adds or modifies
     * account-level configurations in ACM.
     * The
     * supported configuration option is DaysBeforeExpiry. This option specifies the
     * number of days prior to certificate expiration when ACM starts generating
     * EventBridge events. ACM sends one event per day per certificate until the
     * certificate expires. By default, accounts receive events starting 45 days before certificate
     * expiration.
     */
    suspend fun putAccountConfiguration(block: PutAccountConfigurationRequest.DslBuilder.() -> Unit) = putAccountConfiguration(PutAccountConfigurationRequest.builder().apply(block).build())

    /**
     * Remove one or more tags from an ACM certificate. A tag consists of a key-value pair. If
     * you do not specify the value portion of the tag when calling this function, the tag will be
     * removed regardless of value. If you specify a value, the tag is removed only if it is
     * associated with the specified value.
     * To add tags to a certificate, use the AddTagsToCertificate action. To
     * view all of the tags that have been applied to a specific ACM certificate, use the ListTagsForCertificate action.
     */
    suspend fun removeTagsFromCertificate(input: RemoveTagsFromCertificateRequest): RemoveTagsFromCertificateResponse

    /**
     * Remove one or more tags from an ACM certificate. A tag consists of a key-value pair. If
     * you do not specify the value portion of the tag when calling this function, the tag will be
     * removed regardless of value. If you specify a value, the tag is removed only if it is
     * associated with the specified value.
     * To add tags to a certificate, use the AddTagsToCertificate action. To
     * view all of the tags that have been applied to a specific ACM certificate, use the ListTagsForCertificate action.
     */
    suspend fun removeTagsFromCertificate(block: RemoveTagsFromCertificateRequest.DslBuilder.() -> Unit) = removeTagsFromCertificate(RemoveTagsFromCertificateRequest.builder().apply(block).build())

    /**
     * Renews an eligible ACM certificate. At this time, only exported private certificates can
     * be renewed with this operation. In order to renew your ACM PCA certificates with ACM, you must
     * first <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaPermissions.html">grant the ACM
     * service principal permission to do so. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/manual-renewal.html">Testing Managed Renewal
     * in the ACM User Guide.
     */
    suspend fun renewCertificate(input: RenewCertificateRequest): RenewCertificateResponse

    /**
     * Renews an eligible ACM certificate. At this time, only exported private certificates can
     * be renewed with this operation. In order to renew your ACM PCA certificates with ACM, you must
     * first <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaPermissions.html">grant the ACM
     * service principal permission to do so. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/manual-renewal.html">Testing Managed Renewal
     * in the ACM User Guide.
     */
    suspend fun renewCertificate(block: RenewCertificateRequest.DslBuilder.() -> Unit) = renewCertificate(RenewCertificateRequest.builder().apply(block).build())

    /**
     * Requests an ACM certificate for use with other Amazon Web Services services. To request an ACM
     * certificate, you must specify a fully qualified domain name (FQDN) in the
     * DomainName parameter. You can also specify additional FQDNs in the
     * SubjectAlternativeNames parameter.
     * If you are requesting a private certificate, domain validation is not required. If you are
     * requesting a public certificate, each domain name that you specify must be validated to verify
     * that you own or control the domain. You can use <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">DNS validation or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">email validation.
     * We recommend that you use DNS validation. ACM issues public certificates after receiving
     * approval from the domain owner.
     * ACM behavior differs from the <a href="https://tools.ietf.org/html/rfc6125#appendix-B.2">https://tools.ietf.org/html/rfc6125#appendix-B.2RFC 6125 specification of the
     * certificate validation process. first checks for a subject alternative name, and, if it
     * finds one, ignores the common name (CN)
     */
    suspend fun requestCertificate(input: RequestCertificateRequest): RequestCertificateResponse

    /**
     * Requests an ACM certificate for use with other Amazon Web Services services. To request an ACM
     * certificate, you must specify a fully qualified domain name (FQDN) in the
     * DomainName parameter. You can also specify additional FQDNs in the
     * SubjectAlternativeNames parameter.
     * If you are requesting a private certificate, domain validation is not required. If you are
     * requesting a public certificate, each domain name that you specify must be validated to verify
     * that you own or control the domain. You can use <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">DNS validation or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">email validation.
     * We recommend that you use DNS validation. ACM issues public certificates after receiving
     * approval from the domain owner.
     * ACM behavior differs from the <a href="https://tools.ietf.org/html/rfc6125#appendix-B.2">https://tools.ietf.org/html/rfc6125#appendix-B.2RFC 6125 specification of the
     * certificate validation process. first checks for a subject alternative name, and, if it
     * finds one, ignores the common name (CN)
     */
    suspend fun requestCertificate(block: RequestCertificateRequest.DslBuilder.() -> Unit) = requestCertificate(RequestCertificateRequest.builder().apply(block).build())

    /**
     * Resends the email that requests domain ownership validation. The domain owner or an
     * authorized representative must approve the ACM certificate before it can be issued. The
     * certificate can be approved by clicking a link in the mail to navigate to the Amazon
     * certificate approval website and then clicking I Approve.
     * However, the validation email can be blocked by spam filters. Therefore, if you do not receive
     * the original mail, you can request that the mail be resent within 72 hours of requesting the
     * ACM certificate. If more than 72 hours have elapsed since your original request or since
     * your last attempt to resend validation mail, you must request a new certificate. For more
     * information about setting up your contact email addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html">Configure Email for your Domain.
     */
    suspend fun resendValidationEmail(input: ResendValidationEmailRequest): ResendValidationEmailResponse

    /**
     * Resends the email that requests domain ownership validation. The domain owner or an
     * authorized representative must approve the ACM certificate before it can be issued. The
     * certificate can be approved by clicking a link in the mail to navigate to the Amazon
     * certificate approval website and then clicking I Approve.
     * However, the validation email can be blocked by spam filters. Therefore, if you do not receive
     * the original mail, you can request that the mail be resent within 72 hours of requesting the
     * ACM certificate. If more than 72 hours have elapsed since your original request or since
     * your last attempt to resend validation mail, you must request a new certificate. For more
     * information about setting up your contact email addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html">Configure Email for your Domain.
     */
    suspend fun resendValidationEmail(block: ResendValidationEmailRequest.DslBuilder.() -> Unit) = resendValidationEmail(ResendValidationEmailRequest.builder().apply(block).build())

    /**
     * Updates a certificate. Currently, you can use this function to specify whether to opt in
     * to or out of recording your certificate in a certificate transparency log. For more
     * information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency"> Opting Out of
     * Certificate Transparency Logging.
     */
    suspend fun updateCertificateOptions(input: UpdateCertificateOptionsRequest): UpdateCertificateOptionsResponse

    /**
     * Updates a certificate. Currently, you can use this function to specify whether to opt in
     * to or out of recording your certificate in a certificate transparency log. For more
     * information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency"> Opting Out of
     * Certificate Transparency Logging.
     */
    suspend fun updateCertificateOptions(block: UpdateCertificateOptionsRequest.DslBuilder.() -> Unit) = updateCertificateOptions(UpdateCertificateOptionsRequest.builder().apply(block).build())
}
