// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ServiceEndpointResolver
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.acm.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.acm.model.*
import aws.smithy.kotlin.runtime.http.middleware.RetryFeature
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation

private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

internal fun registerAddTagsToCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<AddTagsToCertificateRequest,AddTagsToCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerDeleteCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<DeleteCertificateRequest,DeleteCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerDescribeCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<DescribeCertificateRequest,DescribeCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerExportCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<ExportCertificateRequest,ExportCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerGetAccountConfigurationMiddleware(config: AcmClient.Config, op: SdkHttpOperation<GetAccountConfigurationRequest,GetAccountConfigurationResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerGetCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<GetCertificateRequest,GetCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerImportCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<ImportCertificateRequest,ImportCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerListCertificatesMiddleware(config: AcmClient.Config, op: SdkHttpOperation<ListCertificatesRequest,ListCertificatesResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerListTagsForCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<ListTagsForCertificateRequest,ListTagsForCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerPutAccountConfigurationMiddleware(config: AcmClient.Config, op: SdkHttpOperation<PutAccountConfigurationRequest,PutAccountConfigurationResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerRemoveTagsFromCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<RemoveTagsFromCertificateRequest,RemoveTagsFromCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerRenewCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<RenewCertificateRequest,RenewCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerRequestCertificateMiddleware(config: AcmClient.Config, op: SdkHttpOperation<RequestCertificateRequest,RequestCertificateResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerResendValidationEmailMiddleware(config: AcmClient.Config, op: SdkHttpOperation<ResendValidationEmailRequest,ResendValidationEmailResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}

internal fun registerUpdateCertificateOptionsMiddleware(config: AcmClient.Config, op: SdkHttpOperation<UpdateCertificateOptionsRequest,UpdateCertificateOptionsResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "CertificateManager"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "acm"
        }
    }
}
