// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about an ACM certificate. This structure is returned in the response
 * to a DescribeCertificate request.
 */
class CertificateDetail private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
     * the Amazon Web Services General Reference.
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued
     * the certificate. This has the following format:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     */
    val certificateAuthorityArn: String? = builder.certificateAuthorityArn
    /**
     * The time at which the certificate was requested.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The fully qualified domain name for the certificate, such as www.example.com or
     * example.com.
     */
    val domainName: String? = builder.domainName
    /**
     * Contains information about the initial validation of each domain name that occurs as a
     * result of the RequestCertificate request. This field exists only when the
     * certificate type is AMAZON_ISSUED.
     */
    val domainValidationOptions: List<DomainValidation>? = builder.domainValidationOptions
    /**
     * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a
     * purpose for which the certificate public key can be used and consists of a name and an object
     * identifier (OID).
     */
    val extendedKeyUsages: List<ExtendedKeyUsage>? = builder.extendedKeyUsages
    /**
     * The reason the certificate request failed. This value exists only when the certificate
     * status is FAILED. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request
     * Failed in the Amazon Web Services Certificate Manager User Guide.
     */
    val failureReason: FailureReason? = builder.failureReason
    /**
     * The date and time at which the certificate was imported. This value exists only when the
     * certificate type is IMPORTED.
     */
    val importedAt: Instant? = builder.importedAt
    /**
     * A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can
     * be used by multiple Amazon Web Services resources.
     */
    val inUseBy: List<String>? = builder.inUseBy
    /**
     * The time at which the certificate was issued. This value exists only when the certificate
     * type is AMAZON_ISSUED.
     */
    val issuedAt: Instant? = builder.issuedAt
    /**
     * The name of the certificate authority that issued and signed the certificate.
     */
    val issuer: String? = builder.issuer
    /**
     * The algorithm that was used to generate the public-private key pair.
     */
    val keyAlgorithm: KeyAlgorithm? = builder.keyAlgorithm
    /**
     * A list of Key Usage X.509 v3 extension objects. Each object is a string value that
     * identifies the purpose of the public key contained in the certificate. Possible extension
     * values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
     */
    val keyUsages: List<KeyUsage>? = builder.keyUsages
    /**
     * The time after which the certificate is not valid.
     */
    val notAfter: Instant? = builder.notAfter
    /**
     * The time before which the certificate is not valid.
     */
    val notBefore: Instant? = builder.notBefore
    /**
     * Value that specifies whether to add the certificate to a transparency log. Certificate
     * transparency makes it possible to detect SSL certificates that have been mistakenly or
     * maliciously issued. A browser might respond to certificate that has not been logged by showing
     * an error message. The logs are cryptographically secure.
     */
    val options: CertificateOptions? = builder.options
    /**
     * Specifies whether the certificate is eligible for renewal. At this time, only exported
     * private certificates can be renewed with the RenewCertificate
     * command.
     */
    val renewalEligibility: RenewalEligibility? = builder.renewalEligibility
    /**
     * Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for the certificate. This field
     * exists only when the certificate type is AMAZON_ISSUED.
     */
    val renewalSummary: RenewalSummary? = builder.renewalSummary
    /**
     * The reason the certificate was revoked. This value exists only when the certificate status
     * is REVOKED.
     */
    val revocationReason: RevocationReason? = builder.revocationReason
    /**
     * The time at which the certificate was revoked. This value exists only when the certificate
     * status is REVOKED.
     */
    val revokedAt: Instant? = builder.revokedAt
    /**
     * The serial number of the certificate.
     */
    val serial: String? = builder.serial
    /**
     * The algorithm that was used to sign the certificate.
     */
    val signatureAlgorithm: String? = builder.signatureAlgorithm
    /**
     * The status of the certificate.
     */
    val status: CertificateStatus? = builder.status
    /**
     * The name of the entity that is associated with the public key contained in the
     * certificate.
     */
    val subject: String? = builder.subject
    /**
     * One or more domain names (subject alternative names) included in the certificate. This
     * list contains the domain names that are bound to the public key that is contained in the
     * certificate. The subject alternative names include the canonical domain name (CN) of the
     * certificate and additional domain names that can be used to connect to the website.
     */
    val subjectAlternativeNames: List<String>? = builder.subjectAlternativeNames
    /**
     * The source of the certificate. For certificates provided by ACM, this value is
     * AMAZON_ISSUED. For certificates that you imported with ImportCertificate, this value is IMPORTED. ACM does not provide
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for
     * imported certificates. For more information about the differences between certificates that
     * you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates in the
     * Amazon Web Services Certificate Manager User Guide.
     */
    val type: CertificateType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CertificateDetail = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateDetail(")
        append("certificateArn=$certificateArn,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("domainValidationOptions=$domainValidationOptions,")
        append("extendedKeyUsages=$extendedKeyUsages,")
        append("failureReason=$failureReason,")
        append("importedAt=$importedAt,")
        append("inUseBy=$inUseBy,")
        append("issuedAt=$issuedAt,")
        append("issuer=$issuer,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("keyUsages=$keyUsages,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("options=$options,")
        append("renewalEligibility=$renewalEligibility,")
        append("renewalSummary=$renewalSummary,")
        append("revocationReason=$revocationReason,")
        append("revokedAt=$revokedAt,")
        append("serial=$serial,")
        append("signatureAlgorithm=$signatureAlgorithm,")
        append("status=$status,")
        append("subject=$subject,")
        append("subjectAlternativeNames=$subjectAlternativeNames,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainValidationOptions?.hashCode() ?: 0)
        result = 31 * result + (extendedKeyUsages?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (importedAt?.hashCode() ?: 0)
        result = 31 * result + (inUseBy?.hashCode() ?: 0)
        result = 31 * result + (issuedAt?.hashCode() ?: 0)
        result = 31 * result + (issuer?.hashCode() ?: 0)
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (keyUsages?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (renewalEligibility?.hashCode() ?: 0)
        result = 31 * result + (renewalSummary?.hashCode() ?: 0)
        result = 31 * result + (revocationReason?.hashCode() ?: 0)
        result = 31 * result + (revokedAt?.hashCode() ?: 0)
        result = 31 * result + (serial?.hashCode() ?: 0)
        result = 31 * result + (signatureAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CertificateDetail

        if (certificateArn != other.certificateArn) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (domainValidationOptions != other.domainValidationOptions) return false
        if (extendedKeyUsages != other.extendedKeyUsages) return false
        if (failureReason != other.failureReason) return false
        if (importedAt != other.importedAt) return false
        if (inUseBy != other.inUseBy) return false
        if (issuedAt != other.issuedAt) return false
        if (issuer != other.issuer) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (keyUsages != other.keyUsages) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (options != other.options) return false
        if (renewalEligibility != other.renewalEligibility) return false
        if (renewalSummary != other.renewalSummary) return false
        if (revocationReason != other.revocationReason) return false
        if (revokedAt != other.revokedAt) return false
        if (serial != other.serial) return false
        if (signatureAlgorithm != other.signatureAlgorithm) return false
        if (status != other.status) return false
        if (subject != other.subject) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CertificateDetail = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CertificateDetail
        /**
         * The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
         * the Amazon Web Services General Reference.
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued
         * the certificate. This has the following format:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder
        /**
         * The time at which the certificate was requested.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The fully qualified domain name for the certificate, such as www.example.com or
         * example.com.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * Contains information about the initial validation of each domain name that occurs as a
         * result of the RequestCertificate request. This field exists only when the
         * certificate type is AMAZON_ISSUED.
         */
        fun domainValidationOptions(domainValidationOptions: List<DomainValidation>): FluentBuilder
        /**
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a
         * purpose for which the certificate public key can be used and consists of a name and an object
         * identifier (OID).
         */
        fun extendedKeyUsages(extendedKeyUsages: List<ExtendedKeyUsage>): FluentBuilder
        /**
         * The reason the certificate request failed. This value exists only when the certificate
         * status is FAILED. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request
         * Failed in the Amazon Web Services Certificate Manager User Guide.
         */
        fun failureReason(failureReason: FailureReason): FluentBuilder
        /**
         * The date and time at which the certificate was imported. This value exists only when the
         * certificate type is IMPORTED.
         */
        fun importedAt(importedAt: Instant): FluentBuilder
        /**
         * A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can
         * be used by multiple Amazon Web Services resources.
         */
        fun inUseBy(inUseBy: List<String>): FluentBuilder
        /**
         * The time at which the certificate was issued. This value exists only when the certificate
         * type is AMAZON_ISSUED.
         */
        fun issuedAt(issuedAt: Instant): FluentBuilder
        /**
         * The name of the certificate authority that issued and signed the certificate.
         */
        fun issuer(issuer: String): FluentBuilder
        /**
         * The algorithm that was used to generate the public-private key pair.
         */
        fun keyAlgorithm(keyAlgorithm: KeyAlgorithm): FluentBuilder
        /**
         * A list of Key Usage X.509 v3 extension objects. Each object is a string value that
         * identifies the purpose of the public key contained in the certificate. Possible extension
         * values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
         */
        fun keyUsages(keyUsages: List<KeyUsage>): FluentBuilder
        /**
         * The time after which the certificate is not valid.
         */
        fun notAfter(notAfter: Instant): FluentBuilder
        /**
         * The time before which the certificate is not valid.
         */
        fun notBefore(notBefore: Instant): FluentBuilder
        /**
         * Value that specifies whether to add the certificate to a transparency log. Certificate
         * transparency makes it possible to detect SSL certificates that have been mistakenly or
         * maliciously issued. A browser might respond to certificate that has not been logged by showing
         * an error message. The logs are cryptographically secure.
         */
        fun options(options: CertificateOptions): FluentBuilder
        /**
         * Specifies whether the certificate is eligible for renewal. At this time, only exported
         * private certificates can be renewed with the RenewCertificate
         * command.
         */
        fun renewalEligibility(renewalEligibility: RenewalEligibility): FluentBuilder
        /**
         * Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for the certificate. This field
         * exists only when the certificate type is AMAZON_ISSUED.
         */
        fun renewalSummary(renewalSummary: RenewalSummary): FluentBuilder
        /**
         * The reason the certificate was revoked. This value exists only when the certificate status
         * is REVOKED.
         */
        fun revocationReason(revocationReason: RevocationReason): FluentBuilder
        /**
         * The time at which the certificate was revoked. This value exists only when the certificate
         * status is REVOKED.
         */
        fun revokedAt(revokedAt: Instant): FluentBuilder
        /**
         * The serial number of the certificate.
         */
        fun serial(serial: String): FluentBuilder
        /**
         * The algorithm that was used to sign the certificate.
         */
        fun signatureAlgorithm(signatureAlgorithm: String): FluentBuilder
        /**
         * The status of the certificate.
         */
        fun status(status: CertificateStatus): FluentBuilder
        /**
         * The name of the entity that is associated with the public key contained in the
         * certificate.
         */
        fun subject(subject: String): FluentBuilder
        /**
         * One or more domain names (subject alternative names) included in the certificate. This
         * list contains the domain names that are bound to the public key that is contained in the
         * certificate. The subject alternative names include the canonical domain name (CN) of the
         * certificate and additional domain names that can be used to connect to the website.
         */
        fun subjectAlternativeNames(subjectAlternativeNames: List<String>): FluentBuilder
        /**
         * The source of the certificate. For certificates provided by ACM, this value is
         * AMAZON_ISSUED. For certificates that you imported with ImportCertificate, this value is IMPORTED. ACM does not provide
         * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for
         * imported certificates. For more information about the differences between certificates that
         * you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates in the
         * Amazon Web Services Certificate Manager User Guide.
         */
        fun type(type: CertificateType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
         * the Amazon Web Services General Reference.
         */
        var certificateArn: String?
        /**
         * The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued
         * the certificate. This has the following format:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        var certificateAuthorityArn: String?
        /**
         * The time at which the certificate was requested.
         */
        var createdAt: Instant?
        /**
         * The fully qualified domain name for the certificate, such as www.example.com or
         * example.com.
         */
        var domainName: String?
        /**
         * Contains information about the initial validation of each domain name that occurs as a
         * result of the RequestCertificate request. This field exists only when the
         * certificate type is AMAZON_ISSUED.
         */
        var domainValidationOptions: List<DomainValidation>?
        /**
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a
         * purpose for which the certificate public key can be used and consists of a name and an object
         * identifier (OID).
         */
        var extendedKeyUsages: List<ExtendedKeyUsage>?
        /**
         * The reason the certificate request failed. This value exists only when the certificate
         * status is FAILED. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request
         * Failed in the Amazon Web Services Certificate Manager User Guide.
         */
        var failureReason: FailureReason?
        /**
         * The date and time at which the certificate was imported. This value exists only when the
         * certificate type is IMPORTED.
         */
        var importedAt: Instant?
        /**
         * A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can
         * be used by multiple Amazon Web Services resources.
         */
        var inUseBy: List<String>?
        /**
         * The time at which the certificate was issued. This value exists only when the certificate
         * type is AMAZON_ISSUED.
         */
        var issuedAt: Instant?
        /**
         * The name of the certificate authority that issued and signed the certificate.
         */
        var issuer: String?
        /**
         * The algorithm that was used to generate the public-private key pair.
         */
        var keyAlgorithm: KeyAlgorithm?
        /**
         * A list of Key Usage X.509 v3 extension objects. Each object is a string value that
         * identifies the purpose of the public key contained in the certificate. Possible extension
         * values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
         */
        var keyUsages: List<KeyUsage>?
        /**
         * The time after which the certificate is not valid.
         */
        var notAfter: Instant?
        /**
         * The time before which the certificate is not valid.
         */
        var notBefore: Instant?
        /**
         * Value that specifies whether to add the certificate to a transparency log. Certificate
         * transparency makes it possible to detect SSL certificates that have been mistakenly or
         * maliciously issued. A browser might respond to certificate that has not been logged by showing
         * an error message. The logs are cryptographically secure.
         */
        var options: CertificateOptions?
        /**
         * Specifies whether the certificate is eligible for renewal. At this time, only exported
         * private certificates can be renewed with the RenewCertificate
         * command.
         */
        var renewalEligibility: RenewalEligibility?
        /**
         * Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for the certificate. This field
         * exists only when the certificate type is AMAZON_ISSUED.
         */
        var renewalSummary: RenewalSummary?
        /**
         * The reason the certificate was revoked. This value exists only when the certificate status
         * is REVOKED.
         */
        var revocationReason: RevocationReason?
        /**
         * The time at which the certificate was revoked. This value exists only when the certificate
         * status is REVOKED.
         */
        var revokedAt: Instant?
        /**
         * The serial number of the certificate.
         */
        var serial: String?
        /**
         * The algorithm that was used to sign the certificate.
         */
        var signatureAlgorithm: String?
        /**
         * The status of the certificate.
         */
        var status: CertificateStatus?
        /**
         * The name of the entity that is associated with the public key contained in the
         * certificate.
         */
        var subject: String?
        /**
         * One or more domain names (subject alternative names) included in the certificate. This
         * list contains the domain names that are bound to the public key that is contained in the
         * certificate. The subject alternative names include the canonical domain name (CN) of the
         * certificate and additional domain names that can be used to connect to the website.
         */
        var subjectAlternativeNames: List<String>?
        /**
         * The source of the certificate. For certificates provided by ACM, this value is
         * AMAZON_ISSUED. For certificates that you imported with ImportCertificate, this value is IMPORTED. ACM does not provide
         * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for
         * imported certificates. For more information about the differences between certificates that
         * you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates in the
         * Amazon Web Services Certificate Manager User Guide.
         */
        var type: CertificateType?

        fun build(): CertificateDetail
        /**
         * construct an [aws.sdk.kotlin.services.acm.model.CertificateOptions] inside the given [block]
         */
        fun options(block: CertificateOptions.DslBuilder.() -> kotlin.Unit) {
            this.options = CertificateOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.acm.model.RenewalSummary] inside the given [block]
         */
        fun renewalSummary(block: RenewalSummary.DslBuilder.() -> kotlin.Unit) {
            this.renewalSummary = RenewalSummary.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateArn: String? = null
        override var certificateAuthorityArn: String? = null
        override var createdAt: Instant? = null
        override var domainName: String? = null
        override var domainValidationOptions: List<DomainValidation>? = null
        override var extendedKeyUsages: List<ExtendedKeyUsage>? = null
        override var failureReason: FailureReason? = null
        override var importedAt: Instant? = null
        override var inUseBy: List<String>? = null
        override var issuedAt: Instant? = null
        override var issuer: String? = null
        override var keyAlgorithm: KeyAlgorithm? = null
        override var keyUsages: List<KeyUsage>? = null
        override var notAfter: Instant? = null
        override var notBefore: Instant? = null
        override var options: CertificateOptions? = null
        override var renewalEligibility: RenewalEligibility? = null
        override var renewalSummary: RenewalSummary? = null
        override var revocationReason: RevocationReason? = null
        override var revokedAt: Instant? = null
        override var serial: String? = null
        override var signatureAlgorithm: String? = null
        override var status: CertificateStatus? = null
        override var subject: String? = null
        override var subjectAlternativeNames: List<String>? = null
        override var type: CertificateType? = null

        constructor(x: CertificateDetail) : this() {
            this.certificateArn = x.certificateArn
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.domainValidationOptions = x.domainValidationOptions
            this.extendedKeyUsages = x.extendedKeyUsages
            this.failureReason = x.failureReason
            this.importedAt = x.importedAt
            this.inUseBy = x.inUseBy
            this.issuedAt = x.issuedAt
            this.issuer = x.issuer
            this.keyAlgorithm = x.keyAlgorithm
            this.keyUsages = x.keyUsages
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.options = x.options
            this.renewalEligibility = x.renewalEligibility
            this.renewalSummary = x.renewalSummary
            this.revocationReason = x.revocationReason
            this.revokedAt = x.revokedAt
            this.serial = x.serial
            this.signatureAlgorithm = x.signatureAlgorithm
            this.status = x.status
            this.subject = x.subject
            this.subjectAlternativeNames = x.subjectAlternativeNames
            this.type = x.type
        }

        override fun build(): CertificateDetail = CertificateDetail(this)
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder = apply { this.certificateAuthorityArn = certificateAuthorityArn }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun domainValidationOptions(domainValidationOptions: List<DomainValidation>): FluentBuilder = apply { this.domainValidationOptions = domainValidationOptions }
        override fun extendedKeyUsages(extendedKeyUsages: List<ExtendedKeyUsage>): FluentBuilder = apply { this.extendedKeyUsages = extendedKeyUsages }
        override fun failureReason(failureReason: FailureReason): FluentBuilder = apply { this.failureReason = failureReason }
        override fun importedAt(importedAt: Instant): FluentBuilder = apply { this.importedAt = importedAt }
        override fun inUseBy(inUseBy: List<String>): FluentBuilder = apply { this.inUseBy = inUseBy }
        override fun issuedAt(issuedAt: Instant): FluentBuilder = apply { this.issuedAt = issuedAt }
        override fun issuer(issuer: String): FluentBuilder = apply { this.issuer = issuer }
        override fun keyAlgorithm(keyAlgorithm: KeyAlgorithm): FluentBuilder = apply { this.keyAlgorithm = keyAlgorithm }
        override fun keyUsages(keyUsages: List<KeyUsage>): FluentBuilder = apply { this.keyUsages = keyUsages }
        override fun notAfter(notAfter: Instant): FluentBuilder = apply { this.notAfter = notAfter }
        override fun notBefore(notBefore: Instant): FluentBuilder = apply { this.notBefore = notBefore }
        override fun options(options: CertificateOptions): FluentBuilder = apply { this.options = options }
        override fun renewalEligibility(renewalEligibility: RenewalEligibility): FluentBuilder = apply { this.renewalEligibility = renewalEligibility }
        override fun renewalSummary(renewalSummary: RenewalSummary): FluentBuilder = apply { this.renewalSummary = renewalSummary }
        override fun revocationReason(revocationReason: RevocationReason): FluentBuilder = apply { this.revocationReason = revocationReason }
        override fun revokedAt(revokedAt: Instant): FluentBuilder = apply { this.revokedAt = revokedAt }
        override fun serial(serial: String): FluentBuilder = apply { this.serial = serial }
        override fun signatureAlgorithm(signatureAlgorithm: String): FluentBuilder = apply { this.signatureAlgorithm = signatureAlgorithm }
        override fun status(status: CertificateStatus): FluentBuilder = apply { this.status = status }
        override fun subject(subject: String): FluentBuilder = apply { this.subject = subject }
        override fun subjectAlternativeNames(subjectAlternativeNames: List<String>): FluentBuilder = apply { this.subjectAlternativeNames = subjectAlternativeNames }
        override fun type(type: CertificateType): FluentBuilder = apply { this.type = type }
    }
}
