// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



/**
 * This structure is returned in the response object of ListCertificates
 * action.
 */
class CertificateSummary private constructor(builder: BuilderImpl) {
    /**
     * Amazon Resource Name (ARN) of the certificate. This is of the form:
     * arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
     * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs).
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * Fully qualified domain name (FQDN), such as www.example.com or example.com, for the
     * certificate.
     */
    val domainName: String? = builder.domainName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CertificateSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateSummary(")
        append("certificateArn=$certificateArn,")
        append("domainName=$domainName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CertificateSummary

        if (certificateArn != other.certificateArn) return false
        if (domainName != other.domainName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CertificateSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CertificateSummary
        /**
         * Amazon Resource Name (ARN) of the certificate. This is of the form:
         * arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
         * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs).
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * Fully qualified domain name (FQDN), such as www.example.com or example.com, for the
         * certificate.
         */
        fun domainName(domainName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon Resource Name (ARN) of the certificate. This is of the form:
         * arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
         * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs).
         */
        var certificateArn: String?
        /**
         * Fully qualified domain name (FQDN), such as www.example.com or example.com, for the
         * certificate.
         */
        var domainName: String?

        fun build(): CertificateSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateArn: String? = null
        override var domainName: String? = null

        constructor(x: CertificateSummary) : this() {
            this.certificateArn = x.certificateArn
            this.domainName = x.domainName
        }

        override fun build(): CertificateSummary = CertificateSummary(this)
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
    }
}
