// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



/**
 * Contains information about the validation of each domain name in the certificate.
 */
class DomainValidation private constructor(builder: BuilderImpl) {
    /**
     * A fully qualified domain name (FQDN) in the certificate. For example,
     * www.example.com or example.com.
     */
    val domainName: String? = builder.domainName
    /**
     * Contains the CNAME record that you add to your DNS database for domain validation. For
     * more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership.
     * Note: The CNAME information that you need does not include the name of your domain. If you
     * include  your domain name in the DNS database CNAME record, validation fails.  For example, if
     * the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only
     * "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.
     */
    val resourceRecord: ResourceRecord? = builder.resourceRecord
    /**
     * The domain name that ACM used to send domain validation emails.
     */
    val validationDomain: String? = builder.validationDomain
    /**
     * A list of email addresses that ACM used to send domain validation emails.
     */
    val validationEmails: List<String>? = builder.validationEmails
    /**
     * Specifies the domain validation method.
     */
    val validationMethod: ValidationMethod? = builder.validationMethod
    /**
     * The validation status of the domain name. This can be one of the following values:
     * PENDING_VALIDATION
     * SUCCESS
     * FAILED
     */
    val validationStatus: DomainStatus? = builder.validationStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DomainValidation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DomainValidation(")
        append("domainName=$domainName,")
        append("resourceRecord=$resourceRecord,")
        append("validationDomain=$validationDomain,")
        append("validationEmails=$validationEmails,")
        append("validationMethod=$validationMethod,")
        append("validationStatus=$validationStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (resourceRecord?.hashCode() ?: 0)
        result = 31 * result + (validationDomain?.hashCode() ?: 0)
        result = 31 * result + (validationEmails?.hashCode() ?: 0)
        result = 31 * result + (validationMethod?.hashCode() ?: 0)
        result = 31 * result + (validationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DomainValidation

        if (domainName != other.domainName) return false
        if (resourceRecord != other.resourceRecord) return false
        if (validationDomain != other.validationDomain) return false
        if (validationEmails != other.validationEmails) return false
        if (validationMethod != other.validationMethod) return false
        if (validationStatus != other.validationStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DomainValidation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DomainValidation
        /**
         * A fully qualified domain name (FQDN) in the certificate. For example,
         * www.example.com or example.com.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * Contains the CNAME record that you add to your DNS database for domain validation. For
         * more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership.
         * Note: The CNAME information that you need does not include the name of your domain. If you
         * include  your domain name in the DNS database CNAME record, validation fails.  For example, if
         * the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only
         * "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.
         */
        fun resourceRecord(resourceRecord: ResourceRecord): FluentBuilder
        /**
         * The domain name that ACM used to send domain validation emails.
         */
        fun validationDomain(validationDomain: String): FluentBuilder
        /**
         * A list of email addresses that ACM used to send domain validation emails.
         */
        fun validationEmails(validationEmails: List<String>): FluentBuilder
        /**
         * Specifies the domain validation method.
         */
        fun validationMethod(validationMethod: ValidationMethod): FluentBuilder
        /**
         * The validation status of the domain name. This can be one of the following values:
         * PENDING_VALIDATION
         * SUCCESS
         * FAILED
         */
        fun validationStatus(validationStatus: DomainStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A fully qualified domain name (FQDN) in the certificate. For example,
         * www.example.com or example.com.
         */
        var domainName: String?
        /**
         * Contains the CNAME record that you add to your DNS database for domain validation. For
         * more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership.
         * Note: The CNAME information that you need does not include the name of your domain. If you
         * include  your domain name in the DNS database CNAME record, validation fails.  For example, if
         * the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only
         * "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.
         */
        var resourceRecord: ResourceRecord?
        /**
         * The domain name that ACM used to send domain validation emails.
         */
        var validationDomain: String?
        /**
         * A list of email addresses that ACM used to send domain validation emails.
         */
        var validationEmails: List<String>?
        /**
         * Specifies the domain validation method.
         */
        var validationMethod: ValidationMethod?
        /**
         * The validation status of the domain name. This can be one of the following values:
         * PENDING_VALIDATION
         * SUCCESS
         * FAILED
         */
        var validationStatus: DomainStatus?

        fun build(): DomainValidation
        /**
         * construct an [aws.sdk.kotlin.services.acm.model.ResourceRecord] inside the given [block]
         */
        fun resourceRecord(block: ResourceRecord.DslBuilder.() -> kotlin.Unit) {
            this.resourceRecord = ResourceRecord.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainName: String? = null
        override var resourceRecord: ResourceRecord? = null
        override var validationDomain: String? = null
        override var validationEmails: List<String>? = null
        override var validationMethod: ValidationMethod? = null
        override var validationStatus: DomainStatus? = null

        constructor(x: DomainValidation) : this() {
            this.domainName = x.domainName
            this.resourceRecord = x.resourceRecord
            this.validationDomain = x.validationDomain
            this.validationEmails = x.validationEmails
            this.validationMethod = x.validationMethod
            this.validationStatus = x.validationStatus
        }

        override fun build(): DomainValidation = DomainValidation(this)
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun resourceRecord(resourceRecord: ResourceRecord): FluentBuilder = apply { this.resourceRecord = resourceRecord }
        override fun validationDomain(validationDomain: String): FluentBuilder = apply { this.validationDomain = validationDomain }
        override fun validationEmails(validationEmails: List<String>): FluentBuilder = apply { this.validationEmails = validationEmails }
        override fun validationMethod(validationMethod: ValidationMethod): FluentBuilder = apply { this.validationMethod = validationMethod }
        override fun validationStatus(validationStatus: DomainStatus): FluentBuilder = apply { this.validationStatus = validationStatus }
    }
}
