// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



/**
 * Contains information about the domain names that you want ACM to use to send you emails
 * that enable you to validate domain ownership.
 */
class DomainValidationOption private constructor(builder: BuilderImpl) {
    /**
     * A fully qualified domain name (FQDN) in the certificate request.
     */
    val domainName: String? = builder.domainName
    /**
     * The domain name that you want ACM to use to send you validation emails. This domain name
     * is the suffix of the email addresses that you want ACM to use. This must be the same as the
     * DomainName value or a superdomain of the DomainName value. For
     * example, if you request a certificate for testing.example.com, you can specify
     * example.com for this value. In that case, ACM sends domain validation emails
     * to the following five addresses:
     * admin@example.com
     * administrator@example.com
     * hostmaster@example.com
     * postmaster@example.com
     * webmaster@example.com
     */
    val validationDomain: String? = builder.validationDomain

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DomainValidationOption = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DomainValidationOption(")
        append("domainName=$domainName,")
        append("validationDomain=$validationDomain)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (validationDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DomainValidationOption

        if (domainName != other.domainName) return false
        if (validationDomain != other.validationDomain) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DomainValidationOption = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DomainValidationOption
        /**
         * A fully qualified domain name (FQDN) in the certificate request.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The domain name that you want ACM to use to send you validation emails. This domain name
         * is the suffix of the email addresses that you want ACM to use. This must be the same as the
         * DomainName value or a superdomain of the DomainName value. For
         * example, if you request a certificate for testing.example.com, you can specify
         * example.com for this value. In that case, ACM sends domain validation emails
         * to the following five addresses:
         * admin@example.com
         * administrator@example.com
         * hostmaster@example.com
         * postmaster@example.com
         * webmaster@example.com
         */
        fun validationDomain(validationDomain: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A fully qualified domain name (FQDN) in the certificate request.
         */
        var domainName: String?
        /**
         * The domain name that you want ACM to use to send you validation emails. This domain name
         * is the suffix of the email addresses that you want ACM to use. This must be the same as the
         * DomainName value or a superdomain of the DomainName value. For
         * example, if you request a certificate for testing.example.com, you can specify
         * example.com for this value. In that case, ACM sends domain validation emails
         * to the following five addresses:
         * admin@example.com
         * administrator@example.com
         * hostmaster@example.com
         * postmaster@example.com
         * webmaster@example.com
         */
        var validationDomain: String?

        fun build(): DomainValidationOption
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainName: String? = null
        override var validationDomain: String? = null

        constructor(x: DomainValidationOption) : this() {
            this.domainName = x.domainName
            this.validationDomain = x.validationDomain
        }

        override fun build(): DomainValidationOption = DomainValidationOption(this)
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun validationDomain(validationDomain: String): FluentBuilder = apply { this.validationDomain = validationDomain }
    }
}
