// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



/**
 * Object containing
 * expiration events options associated with an Amazon Web Services account.
 */
class ExpiryEventsConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Specifies the number of days prior to certificate expiration when ACM starts generating
     * EventBridge events. ACM sends one event per day per certificate until the
     * certificate expires. By default, accounts receive events starting 45 days before certificate
     * expiration.
     */
    val daysBeforeExpiry: Int? = builder.daysBeforeExpiry

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExpiryEventsConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExpiryEventsConfiguration(")
        append("daysBeforeExpiry=$daysBeforeExpiry)")
    }

    override fun hashCode(): kotlin.Int {
        var result = daysBeforeExpiry ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExpiryEventsConfiguration

        if (daysBeforeExpiry != other.daysBeforeExpiry) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExpiryEventsConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExpiryEventsConfiguration
        /**
         * Specifies the number of days prior to certificate expiration when ACM starts generating
         * EventBridge events. ACM sends one event per day per certificate until the
         * certificate expires. By default, accounts receive events starting 45 days before certificate
         * expiration.
         */
        fun daysBeforeExpiry(daysBeforeExpiry: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the number of days prior to certificate expiration when ACM starts generating
         * EventBridge events. ACM sends one event per day per certificate until the
         * certificate expires. By default, accounts receive events starting 45 days before certificate
         * expiration.
         */
        var daysBeforeExpiry: Int?

        fun build(): ExpiryEventsConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var daysBeforeExpiry: Int? = null

        constructor(x: ExpiryEventsConfiguration) : this() {
            this.daysBeforeExpiry = x.daysBeforeExpiry
        }

        override fun build(): ExpiryEventsConfiguration = ExpiryEventsConfiguration(this)
        override fun daysBeforeExpiry(daysBeforeExpiry: Int): FluentBuilder = apply { this.daysBeforeExpiry = daysBeforeExpiry }
    }
}
