// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



class ExportCertificateRequest private constructor(builder: BuilderImpl) {
    /**
     * An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:
     * arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * Passphrase to associate with the encrypted exported private key. If you want to later
     * decrypt the private key, you must have the passphrase. You can use the following OpenSSL
     * command to decrypt a private key:
     * openssl rsa -in encrypted_key.pem -out decrypted_key.pem
     */
    val passphrase: ByteArray? = builder.passphrase

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExportCertificateRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExportCertificateRequest(")
        append("certificateArn=$certificateArn,")
        append("passphrase=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (passphrase?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportCertificateRequest

        if (certificateArn != other.certificateArn) return false
        if (passphrase != null) {
            if (other.passphrase == null) return false
            if (!passphrase.contentEquals(other.passphrase)) return false
        } else if (other.passphrase != null) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExportCertificateRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExportCertificateRequest
        /**
         * An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:
         * arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * Passphrase to associate with the encrypted exported private key. If you want to later
         * decrypt the private key, you must have the passphrase. You can use the following OpenSSL
         * command to decrypt a private key:
         * openssl rsa -in encrypted_key.pem -out decrypted_key.pem
         */
        fun passphrase(passphrase: ByteArray): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:
         * arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012
         */
        var certificateArn: String?
        /**
         * Passphrase to associate with the encrypted exported private key. If you want to later
         * decrypt the private key, you must have the passphrase. You can use the following OpenSSL
         * command to decrypt a private key:
         * openssl rsa -in encrypted_key.pem -out decrypted_key.pem
         */
        var passphrase: ByteArray?

        fun build(): ExportCertificateRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateArn: String? = null
        override var passphrase: ByteArray? = null

        constructor(x: ExportCertificateRequest) : this() {
            this.certificateArn = x.certificateArn
            this.passphrase = x.passphrase
        }

        override fun build(): ExportCertificateRequest = ExportCertificateRequest(this)
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun passphrase(passphrase: ByteArray): FluentBuilder = apply { this.passphrase = passphrase }
    }
}
