// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



class ImportCertificateRequest private constructor(builder: BuilderImpl) {
    /**
     * The certificate to import.
     */
    val certificate: ByteArray? = builder.certificate
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN) of an imported certificate to replace. To import a new certificate, omit this
     * field.
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * The PEM encoded certificate chain.
     */
    val certificateChain: ByteArray? = builder.certificateChain
    /**
     * The private key that matches the public key in the certificate.
     */
    val privateKey: ByteArray? = builder.privateKey
    /**
     * One or more resource tags to associate with the imported certificate.
     * Note: You cannot apply tags when reimporting a certificate.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportCertificateRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportCertificateRequest(")
        append("certificate=$certificate,")
        append("certificateArn=$certificateArn,")
        append("certificateChain=$certificateChain,")
        append("privateKey=*** Sensitive Data Redacted ***,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.contentHashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (certificateChain?.contentHashCode() ?: 0)
        result = 31 * result + (privateKey?.contentHashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportCertificateRequest

        if (certificate != null) {
            if (other.certificate == null) return false
            if (!certificate.contentEquals(other.certificate)) return false
        } else if (other.certificate != null) return false
        if (certificateArn != other.certificateArn) return false
        if (certificateChain != null) {
            if (other.certificateChain == null) return false
            if (!certificateChain.contentEquals(other.certificateChain)) return false
        } else if (other.certificateChain != null) return false
        if (privateKey != null) {
            if (other.privateKey == null) return false
            if (!privateKey.contentEquals(other.privateKey)) return false
        } else if (other.privateKey != null) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportCertificateRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportCertificateRequest
        /**
         * The certificate to import.
         */
        fun certificate(certificate: ByteArray): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN) of an imported certificate to replace. To import a new certificate, omit this
         * field.
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * The PEM encoded certificate chain.
         */
        fun certificateChain(certificateChain: ByteArray): FluentBuilder
        /**
         * The private key that matches the public key in the certificate.
         */
        fun privateKey(privateKey: ByteArray): FluentBuilder
        /**
         * One or more resource tags to associate with the imported certificate.
         * Note: You cannot apply tags when reimporting a certificate.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The certificate to import.
         */
        var certificate: ByteArray?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN) of an imported certificate to replace. To import a new certificate, omit this
         * field.
         */
        var certificateArn: String?
        /**
         * The PEM encoded certificate chain.
         */
        var certificateChain: ByteArray?
        /**
         * The private key that matches the public key in the certificate.
         */
        var privateKey: ByteArray?
        /**
         * One or more resource tags to associate with the imported certificate.
         * Note: You cannot apply tags when reimporting a certificate.
         */
        var tags: List<Tag>?

        fun build(): ImportCertificateRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificate: ByteArray? = null
        override var certificateArn: String? = null
        override var certificateChain: ByteArray? = null
        override var privateKey: ByteArray? = null
        override var tags: List<Tag>? = null

        constructor(x: ImportCertificateRequest) : this() {
            this.certificate = x.certificate
            this.certificateArn = x.certificateArn
            this.certificateChain = x.certificateChain
            this.privateKey = x.privateKey
            this.tags = x.tags
        }

        override fun build(): ImportCertificateRequest = ImportCertificateRequest(this)
        override fun certificate(certificate: ByteArray): FluentBuilder = apply { this.certificate = certificate }
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun certificateChain(certificateChain: ByteArray): FluentBuilder = apply { this.certificateChain = certificateChain }
        override fun privateKey(privateKey: ByteArray): FluentBuilder = apply { this.privateKey = privateKey }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
