// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for the certificate. This
 * structure exists only when the certificate type is AMAZON_ISSUED.
 */
class RenewalSummary private constructor(builder: BuilderImpl) {
    /**
     * Contains information about the validation of each domain name in the certificate, as it
     * pertains to ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed
     * renewal. This is different from the initial validation that occurs as a result of
     * the RequestCertificate request. This field exists only when the certificate
     * type is AMAZON_ISSUED.
     */
    val domainValidationOptions: List<DomainValidation>? = builder.domainValidationOptions
    /**
     * The status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal of the certificate.
     */
    val renewalStatus: RenewalStatus? = builder.renewalStatus
    /**
     * The reason that a renewal request was unsuccessful.
     */
    val renewalStatusReason: FailureReason? = builder.renewalStatusReason
    /**
     * The time at which the renewal summary was last updated.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RenewalSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RenewalSummary(")
        append("domainValidationOptions=$domainValidationOptions,")
        append("renewalStatus=$renewalStatus,")
        append("renewalStatusReason=$renewalStatusReason,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainValidationOptions?.hashCode() ?: 0
        result = 31 * result + (renewalStatus?.hashCode() ?: 0)
        result = 31 * result + (renewalStatusReason?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RenewalSummary

        if (domainValidationOptions != other.domainValidationOptions) return false
        if (renewalStatus != other.renewalStatus) return false
        if (renewalStatusReason != other.renewalStatusReason) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RenewalSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RenewalSummary
        /**
         * Contains information about the validation of each domain name in the certificate, as it
         * pertains to ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed
         * renewal. This is different from the initial validation that occurs as a result of
         * the RequestCertificate request. This field exists only when the certificate
         * type is AMAZON_ISSUED.
         */
        fun domainValidationOptions(domainValidationOptions: List<DomainValidation>): FluentBuilder
        /**
         * The status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal of the certificate.
         */
        fun renewalStatus(renewalStatus: RenewalStatus): FluentBuilder
        /**
         * The reason that a renewal request was unsuccessful.
         */
        fun renewalStatusReason(renewalStatusReason: FailureReason): FluentBuilder
        /**
         * The time at which the renewal summary was last updated.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains information about the validation of each domain name in the certificate, as it
         * pertains to ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed
         * renewal. This is different from the initial validation that occurs as a result of
         * the RequestCertificate request. This field exists only when the certificate
         * type is AMAZON_ISSUED.
         */
        var domainValidationOptions: List<DomainValidation>?
        /**
         * The status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal of the certificate.
         */
        var renewalStatus: RenewalStatus?
        /**
         * The reason that a renewal request was unsuccessful.
         */
        var renewalStatusReason: FailureReason?
        /**
         * The time at which the renewal summary was last updated.
         */
        var updatedAt: Instant?

        fun build(): RenewalSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainValidationOptions: List<DomainValidation>? = null
        override var renewalStatus: RenewalStatus? = null
        override var renewalStatusReason: FailureReason? = null
        override var updatedAt: Instant? = null

        constructor(x: RenewalSummary) : this() {
            this.domainValidationOptions = x.domainValidationOptions
            this.renewalStatus = x.renewalStatus
            this.renewalStatusReason = x.renewalStatusReason
            this.updatedAt = x.updatedAt
        }

        override fun build(): RenewalSummary = RenewalSummary(this)
        override fun domainValidationOptions(domainValidationOptions: List<DomainValidation>): FluentBuilder = apply { this.domainValidationOptions = domainValidationOptions }
        override fun renewalStatus(renewalStatus: RenewalStatus): FluentBuilder = apply { this.renewalStatus = renewalStatus }
        override fun renewalStatusReason(renewalStatusReason: FailureReason): FluentBuilder = apply { this.renewalStatusReason = renewalStatusReason }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
