// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



class ResendValidationEmailRequest private constructor(builder: BuilderImpl) {
    /**
     * String that contains the ARN of the requested certificate. The certificate ARN is
     * generated and returned by the RequestCertificate action as soon as the
     * request is made. By default, using this parameter causes email to be sent to all top-level
     * domains you specified in the certificate request. The ARN must be of the form:
     * arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * The fully qualified domain name (FQDN) of the certificate that needs to be
     * validated.
     */
    val domain: String? = builder.domain
    /**
     * The base validation domain that will act as the suffix of the email addresses that are
     * used to send the emails. This must be the same as the Domain value or a
     * superdomain of the Domain value. For example, if you requested a certificate for
     * site.subdomain.example.com and specify a ValidationDomain of subdomain.example.com, ACM sends email to the
     * domain registrant, technical contact, and administrative contact in WHOIS and the following
     * five addresses:
     * admin@subdomain.example.com
     * administrator@subdomain.example.com
     * hostmaster@subdomain.example.com
     * postmaster@subdomain.example.com
     * webmaster@subdomain.example.com
     */
    val validationDomain: String? = builder.validationDomain

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ResendValidationEmailRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ResendValidationEmailRequest(")
        append("certificateArn=$certificateArn,")
        append("domain=$domain,")
        append("validationDomain=$validationDomain)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (validationDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ResendValidationEmailRequest

        if (certificateArn != other.certificateArn) return false
        if (domain != other.domain) return false
        if (validationDomain != other.validationDomain) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ResendValidationEmailRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ResendValidationEmailRequest
        /**
         * String that contains the ARN of the requested certificate. The certificate ARN is
         * generated and returned by the RequestCertificate action as soon as the
         * request is made. By default, using this parameter causes email to be sent to all top-level
         * domains you specified in the certificate request. The ARN must be of the form:
         * arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * The fully qualified domain name (FQDN) of the certificate that needs to be
         * validated.
         */
        fun domain(domain: String): FluentBuilder
        /**
         * The base validation domain that will act as the suffix of the email addresses that are
         * used to send the emails. This must be the same as the Domain value or a
         * superdomain of the Domain value. For example, if you requested a certificate for
         * site.subdomain.example.com and specify a ValidationDomain of subdomain.example.com, ACM sends email to the
         * domain registrant, technical contact, and administrative contact in WHOIS and the following
         * five addresses:
         * admin@subdomain.example.com
         * administrator@subdomain.example.com
         * hostmaster@subdomain.example.com
         * postmaster@subdomain.example.com
         * webmaster@subdomain.example.com
         */
        fun validationDomain(validationDomain: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * String that contains the ARN of the requested certificate. The certificate ARN is
         * generated and returned by the RequestCertificate action as soon as the
         * request is made. By default, using this parameter causes email to be sent to all top-level
         * domains you specified in the certificate request. The ARN must be of the form:
         * arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
         */
        var certificateArn: String?
        /**
         * The fully qualified domain name (FQDN) of the certificate that needs to be
         * validated.
         */
        var domain: String?
        /**
         * The base validation domain that will act as the suffix of the email addresses that are
         * used to send the emails. This must be the same as the Domain value or a
         * superdomain of the Domain value. For example, if you requested a certificate for
         * site.subdomain.example.com and specify a ValidationDomain of subdomain.example.com, ACM sends email to the
         * domain registrant, technical contact, and administrative contact in WHOIS and the following
         * five addresses:
         * admin@subdomain.example.com
         * administrator@subdomain.example.com
         * hostmaster@subdomain.example.com
         * postmaster@subdomain.example.com
         * webmaster@subdomain.example.com
         */
        var validationDomain: String?

        fun build(): ResendValidationEmailRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateArn: String? = null
        override var domain: String? = null
        override var validationDomain: String? = null

        constructor(x: ResendValidationEmailRequest) : this() {
            this.certificateArn = x.certificateArn
            this.domain = x.domain
            this.validationDomain = x.validationDomain
        }

        override fun build(): ResendValidationEmailRequest = ResendValidationEmailRequest(this)
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun domain(domain: String): FluentBuilder = apply { this.domain = domain }
        override fun validationDomain(validationDomain: String): FluentBuilder = apply { this.validationDomain = validationDomain }
    }
}
