// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



/**
 * Contains a DNS record value that you can use to validate ownership or control
 * of a domain. This is used by the DescribeCertificate action.
 */
class ResourceRecord private constructor(builder: BuilderImpl) {
    /**
     * The name of the DNS record to create in your domain. This is supplied by ACM.
     */
    val name: String? = builder.name
    /**
     * The type of DNS record. Currently this can be CNAME.
     */
    val type: RecordType? = builder.type
    /**
     * The value of the CNAME record to add to your DNS database. This is supplied by
     * ACM.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ResourceRecord = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceRecord(")
        append("name=$name,")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ResourceRecord

        if (name != other.name) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ResourceRecord = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ResourceRecord
        /**
         * The name of the DNS record to create in your domain. This is supplied by ACM.
         */
        fun name(name: String): FluentBuilder
        /**
         * The type of DNS record. Currently this can be CNAME.
         */
        fun type(type: RecordType): FluentBuilder
        /**
         * The value of the CNAME record to add to your DNS database. This is supplied by
         * ACM.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the DNS record to create in your domain. This is supplied by ACM.
         */
        var name: String?
        /**
         * The type of DNS record. Currently this can be CNAME.
         */
        var type: RecordType?
        /**
         * The value of the CNAME record to add to your DNS database. This is supplied by
         * ACM.
         */
        var value: String?

        fun build(): ResourceRecord
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null
        override var type: RecordType? = null
        override var value: String? = null

        constructor(x: ResourceRecord) : this() {
            this.name = x.name
            this.type = x.type
            this.value = x.value
        }

        override fun build(): ResourceRecord = ResourceRecord(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun type(type: RecordType): FluentBuilder = apply { this.type = type }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
