// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.acm.model.AcmException
import aws.sdk.kotlin.services.acm.model.ResendValidationEmailResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class ResendValidationEmailOperationDeserializer: HttpDeserialize<ResendValidationEmailResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ResendValidationEmailResponse {
        if (!response.status.isSuccess()) {
            throwResendValidationEmailError(context, response)
        }
        val builder = ResendValidationEmailResponse.builder()

        return builder.build()
    }
}

private suspend fun throwResendValidationEmailError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidArnException" -> InvalidArnExceptionDeserializer()
        "InvalidDomainValidationOptionsException" -> InvalidDomainValidationOptionsExceptionDeserializer()
        "InvalidStateException" -> InvalidStateExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw AcmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
