// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about an ACM certificate. This structure is returned in the response
 * to a DescribeCertificate request.
 */
class CertificateDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
     * the Amazon Web Services General Reference.
     */
    val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued
     * the certificate. This has the following format:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     */
    val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The time at which the certificate was requested.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The fully qualified domain name for the certificate, such as www.example.com or
     * example.com.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * Contains information about the initial validation of each domain name that occurs as a
     * result of the RequestCertificate request. This field exists only when the
     * certificate type is AMAZON_ISSUED.
     */
    val domainValidationOptions: List<DomainValidation>? = builder.domainValidationOptions
    /**
     * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a
     * purpose for which the certificate public key can be used and consists of a name and an object
     * identifier (OID).
     */
    val extendedKeyUsages: List<ExtendedKeyUsage>? = builder.extendedKeyUsages
    /**
     * The reason the certificate request failed. This value exists only when the certificate
     * status is FAILED. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request
     * Failed in the Amazon Web Services Certificate Manager User Guide.
     */
    val failureReason: aws.sdk.kotlin.services.acm.model.FailureReason? = builder.failureReason
    /**
     * The date and time at which the certificate was imported. This value exists only when the
     * certificate type is IMPORTED.
     */
    val importedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.importedAt
    /**
     * A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can
     * be used by multiple Amazon Web Services resources.
     */
    val inUseBy: List<String>? = builder.inUseBy
    /**
     * The time at which the certificate was issued. This value exists only when the certificate
     * type is AMAZON_ISSUED.
     */
    val issuedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.issuedAt
    /**
     * The name of the certificate authority that issued and signed the certificate.
     */
    val issuer: kotlin.String? = builder.issuer
    /**
     * The algorithm that was used to generate the public-private key pair.
     */
    val keyAlgorithm: aws.sdk.kotlin.services.acm.model.KeyAlgorithm? = builder.keyAlgorithm
    /**
     * A list of Key Usage X.509 v3 extension objects. Each object is a string value that
     * identifies the purpose of the public key contained in the certificate. Possible extension
     * values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
     */
    val keyUsages: List<KeyUsage>? = builder.keyUsages
    /**
     * The time after which the certificate is not valid.
     */
    val notAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.notAfter
    /**
     * The time before which the certificate is not valid.
     */
    val notBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.notBefore
    /**
     * Value that specifies whether to add the certificate to a transparency log. Certificate
     * transparency makes it possible to detect SSL certificates that have been mistakenly or
     * maliciously issued. A browser might respond to certificate that has not been logged by showing
     * an error message. The logs are cryptographically secure.
     */
    val options: aws.sdk.kotlin.services.acm.model.CertificateOptions? = builder.options
    /**
     * Specifies whether the certificate is eligible for renewal. At this time, only exported
     * private certificates can be renewed with the RenewCertificate
     * command.
     */
    val renewalEligibility: aws.sdk.kotlin.services.acm.model.RenewalEligibility? = builder.renewalEligibility
    /**
     * Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for the certificate. This field
     * exists only when the certificate type is AMAZON_ISSUED.
     */
    val renewalSummary: aws.sdk.kotlin.services.acm.model.RenewalSummary? = builder.renewalSummary
    /**
     * The reason the certificate was revoked. This value exists only when the certificate status
     * is REVOKED.
     */
    val revocationReason: aws.sdk.kotlin.services.acm.model.RevocationReason? = builder.revocationReason
    /**
     * The time at which the certificate was revoked. This value exists only when the certificate
     * status is REVOKED.
     */
    val revokedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.revokedAt
    /**
     * The serial number of the certificate.
     */
    val serial: kotlin.String? = builder.serial
    /**
     * The algorithm that was used to sign the certificate.
     */
    val signatureAlgorithm: kotlin.String? = builder.signatureAlgorithm
    /**
     * The status of the certificate.
     */
    val status: aws.sdk.kotlin.services.acm.model.CertificateStatus? = builder.status
    /**
     * The name of the entity that is associated with the public key contained in the
     * certificate.
     */
    val subject: kotlin.String? = builder.subject
    /**
     * One or more domain names (subject alternative names) included in the certificate. This
     * list contains the domain names that are bound to the public key that is contained in the
     * certificate. The subject alternative names include the canonical domain name (CN) of the
     * certificate and additional domain names that can be used to connect to the website.
     */
    val subjectAlternativeNames: List<String>? = builder.subjectAlternativeNames
    /**
     * The source of the certificate. For certificates provided by ACM, this value is
     * AMAZON_ISSUED. For certificates that you imported with ImportCertificate, this value is IMPORTED. ACM does not provide
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for
     * imported certificates. For more information about the differences between certificates that
     * you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates in the
     * Amazon Web Services Certificate Manager User Guide.
     */
    val type: aws.sdk.kotlin.services.acm.model.CertificateType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.CertificateDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateDetail(")
        append("certificateArn=$certificateArn,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("domainValidationOptions=$domainValidationOptions,")
        append("extendedKeyUsages=$extendedKeyUsages,")
        append("failureReason=$failureReason,")
        append("importedAt=$importedAt,")
        append("inUseBy=$inUseBy,")
        append("issuedAt=$issuedAt,")
        append("issuer=$issuer,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("keyUsages=$keyUsages,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("options=$options,")
        append("renewalEligibility=$renewalEligibility,")
        append("renewalSummary=$renewalSummary,")
        append("revocationReason=$revocationReason,")
        append("revokedAt=$revokedAt,")
        append("serial=$serial,")
        append("signatureAlgorithm=$signatureAlgorithm,")
        append("status=$status,")
        append("subject=$subject,")
        append("subjectAlternativeNames=$subjectAlternativeNames,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainValidationOptions?.hashCode() ?: 0)
        result = 31 * result + (extendedKeyUsages?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (importedAt?.hashCode() ?: 0)
        result = 31 * result + (inUseBy?.hashCode() ?: 0)
        result = 31 * result + (issuedAt?.hashCode() ?: 0)
        result = 31 * result + (issuer?.hashCode() ?: 0)
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (keyUsages?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (renewalEligibility?.hashCode() ?: 0)
        result = 31 * result + (renewalSummary?.hashCode() ?: 0)
        result = 31 * result + (revocationReason?.hashCode() ?: 0)
        result = 31 * result + (revokedAt?.hashCode() ?: 0)
        result = 31 * result + (serial?.hashCode() ?: 0)
        result = 31 * result + (signatureAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CertificateDetail

        if (certificateArn != other.certificateArn) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (domainValidationOptions != other.domainValidationOptions) return false
        if (extendedKeyUsages != other.extendedKeyUsages) return false
        if (failureReason != other.failureReason) return false
        if (importedAt != other.importedAt) return false
        if (inUseBy != other.inUseBy) return false
        if (issuedAt != other.issuedAt) return false
        if (issuer != other.issuer) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (keyUsages != other.keyUsages) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (options != other.options) return false
        if (renewalEligibility != other.renewalEligibility) return false
        if (renewalSummary != other.renewalSummary) return false
        if (revocationReason != other.revocationReason) return false
        if (revokedAt != other.revokedAt) return false
        if (serial != other.serial) return false
        if (signatureAlgorithm != other.signatureAlgorithm) return false
        if (status != other.status) return false
        if (subject != other.subject) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.CertificateDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in
         * the Amazon Web Services General Reference.
         */
        var certificateArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued
         * the certificate. This has the following format:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        var certificateAuthorityArn: kotlin.String? = null
        /**
         * The time at which the certificate was requested.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The fully qualified domain name for the certificate, such as www.example.com or
         * example.com.
         */
        var domainName: kotlin.String? = null
        /**
         * Contains information about the initial validation of each domain name that occurs as a
         * result of the RequestCertificate request. This field exists only when the
         * certificate type is AMAZON_ISSUED.
         */
        var domainValidationOptions: List<DomainValidation>? = null
        /**
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a
         * purpose for which the certificate public key can be used and consists of a name and an object
         * identifier (OID).
         */
        var extendedKeyUsages: List<ExtendedKeyUsage>? = null
        /**
         * The reason the certificate request failed. This value exists only when the certificate
         * status is FAILED. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request
         * Failed in the Amazon Web Services Certificate Manager User Guide.
         */
        var failureReason: aws.sdk.kotlin.services.acm.model.FailureReason? = null
        /**
         * The date and time at which the certificate was imported. This value exists only when the
         * certificate type is IMPORTED.
         */
        var importedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can
         * be used by multiple Amazon Web Services resources.
         */
        var inUseBy: List<String>? = null
        /**
         * The time at which the certificate was issued. This value exists only when the certificate
         * type is AMAZON_ISSUED.
         */
        var issuedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the certificate authority that issued and signed the certificate.
         */
        var issuer: kotlin.String? = null
        /**
         * The algorithm that was used to generate the public-private key pair.
         */
        var keyAlgorithm: aws.sdk.kotlin.services.acm.model.KeyAlgorithm? = null
        /**
         * A list of Key Usage X.509 v3 extension objects. Each object is a string value that
         * identifies the purpose of the public key contained in the certificate. Possible extension
         * values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.
         */
        var keyUsages: List<KeyUsage>? = null
        /**
         * The time after which the certificate is not valid.
         */
        var notAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time before which the certificate is not valid.
         */
        var notBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Value that specifies whether to add the certificate to a transparency log. Certificate
         * transparency makes it possible to detect SSL certificates that have been mistakenly or
         * maliciously issued. A browser might respond to certificate that has not been logged by showing
         * an error message. The logs are cryptographically secure.
         */
        var options: aws.sdk.kotlin.services.acm.model.CertificateOptions? = null
        /**
         * Specifies whether the certificate is eligible for renewal. At this time, only exported
         * private certificates can be renewed with the RenewCertificate
         * command.
         */
        var renewalEligibility: aws.sdk.kotlin.services.acm.model.RenewalEligibility? = null
        /**
         * Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for the certificate. This field
         * exists only when the certificate type is AMAZON_ISSUED.
         */
        var renewalSummary: aws.sdk.kotlin.services.acm.model.RenewalSummary? = null
        /**
         * The reason the certificate was revoked. This value exists only when the certificate status
         * is REVOKED.
         */
        var revocationReason: aws.sdk.kotlin.services.acm.model.RevocationReason? = null
        /**
         * The time at which the certificate was revoked. This value exists only when the certificate
         * status is REVOKED.
         */
        var revokedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The serial number of the certificate.
         */
        var serial: kotlin.String? = null
        /**
         * The algorithm that was used to sign the certificate.
         */
        var signatureAlgorithm: kotlin.String? = null
        /**
         * The status of the certificate.
         */
        var status: aws.sdk.kotlin.services.acm.model.CertificateStatus? = null
        /**
         * The name of the entity that is associated with the public key contained in the
         * certificate.
         */
        var subject: kotlin.String? = null
        /**
         * One or more domain names (subject alternative names) included in the certificate. This
         * list contains the domain names that are bound to the public key that is contained in the
         * certificate. The subject alternative names include the canonical domain name (CN) of the
         * certificate and additional domain names that can be used to connect to the website.
         */
        var subjectAlternativeNames: List<String>? = null
        /**
         * The source of the certificate. For certificates provided by ACM, this value is
         * AMAZON_ISSUED. For certificates that you imported with ImportCertificate, this value is IMPORTED. ACM does not provide
         * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal for
         * imported certificates. For more information about the differences between certificates that
         * you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates in the
         * Amazon Web Services Certificate Manager User Guide.
         */
        var type: aws.sdk.kotlin.services.acm.model.CertificateType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.CertificateDetail) : this() {
            this.certificateArn = x.certificateArn
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.domainValidationOptions = x.domainValidationOptions
            this.extendedKeyUsages = x.extendedKeyUsages
            this.failureReason = x.failureReason
            this.importedAt = x.importedAt
            this.inUseBy = x.inUseBy
            this.issuedAt = x.issuedAt
            this.issuer = x.issuer
            this.keyAlgorithm = x.keyAlgorithm
            this.keyUsages = x.keyUsages
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.options = x.options
            this.renewalEligibility = x.renewalEligibility
            this.renewalSummary = x.renewalSummary
            this.revocationReason = x.revocationReason
            this.revokedAt = x.revokedAt
            this.serial = x.serial
            this.signatureAlgorithm = x.signatureAlgorithm
            this.status = x.status
            this.subject = x.subject
            this.subjectAlternativeNames = x.subjectAlternativeNames
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.CertificateDetail = CertificateDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.acm.model.CertificateOptions] inside the given [block]
         */
        fun options(block: aws.sdk.kotlin.services.acm.model.CertificateOptions.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.acm.model.CertificateOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acm.model.RenewalSummary] inside the given [block]
         */
        fun renewalSummary(block: aws.sdk.kotlin.services.acm.model.RenewalSummary.Builder.() -> kotlin.Unit) {
            this.renewalSummary = aws.sdk.kotlin.services.acm.model.RenewalSummary.invoke(block)
        }
    }
}
