// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



/**
 * Structure that contains options for your certificate. Currently, you can use this only to
 * specify whether to opt in to or out of certificate transparency logging. Some browsers require
 * that public certificates issued for your domain be recorded in a log. Certificates that are
 * not logged typically generate a browser error. Transparency makes it possible for you to
 * detect SSL/TLS certificates that have been mistakenly or maliciously issued for your domain.
 * For general information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate Transparency
 * Logging.
 */
class CertificateOptions private constructor(builder: Builder) {
    /**
     * You can opt out of certificate transparency logging by specifying the
     * DISABLED option. Opt in by specifying ENABLED.
     */
    val certificateTransparencyLoggingPreference: aws.sdk.kotlin.services.acm.model.CertificateTransparencyLoggingPreference? = builder.certificateTransparencyLoggingPreference

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.CertificateOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateOptions(")
        append("certificateTransparencyLoggingPreference=$certificateTransparencyLoggingPreference)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateTransparencyLoggingPreference?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CertificateOptions

        if (certificateTransparencyLoggingPreference != other.certificateTransparencyLoggingPreference) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.CertificateOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * You can opt out of certificate transparency logging by specifying the
         * DISABLED option. Opt in by specifying ENABLED.
         */
        var certificateTransparencyLoggingPreference: aws.sdk.kotlin.services.acm.model.CertificateTransparencyLoggingPreference? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.CertificateOptions) : this() {
            this.certificateTransparencyLoggingPreference = x.certificateTransparencyLoggingPreference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.CertificateOptions = CertificateOptions(this)
    }
}
