// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.serde

import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.ResolveRoomResponse
import aws.sdk.kotlin.services.alexaforbusiness.model.RoomSkillParameter
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ResolveRoomOperationDeserializer: HttpDeserialize<ResolveRoomResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ResolveRoomResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwResolveRoomError(context, call)
        }
        val builder = ResolveRoomResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeResolveRoomOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwResolveRoomError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeResolveRoomOperationBody(builder: ResolveRoomResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ROOMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoomArn"))
    val ROOMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoomName"))
    val ROOMSKILLPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RoomSkillParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ROOMARN_DESCRIPTOR)
        field(ROOMNAME_DESCRIPTOR)
        field(ROOMSKILLPARAMETERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ROOMARN_DESCRIPTOR.index -> builder.roomArn = deserializeString()
                ROOMNAME_DESCRIPTOR.index -> builder.roomName = deserializeString()
                ROOMSKILLPARAMETERS_DESCRIPTOR.index -> builder.roomSkillParameters =
                    deserializer.deserializeList(ROOMSKILLPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<RoomSkillParameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRoomSkillParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
