// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.serde

import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.CreateConferenceProviderResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateConferenceProviderOperationDeserializer: HttpDeserializer.NonStreaming<CreateConferenceProviderResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateConferenceProviderResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateConferenceProviderError(context, call, payload)
        }
        val builder = CreateConferenceProviderResponse.Builder()

        if (payload != null) {
            deserializeCreateConferenceProviderOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateConferenceProviderError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateConferenceProviderOperationBody(builder: CreateConferenceProviderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFERENCEPROVIDERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConferenceProviderArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFERENCEPROVIDERARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFERENCEPROVIDERARN_DESCRIPTOR.index -> builder.conferenceProviderArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
