// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.alexaforbusiness.auth.AlexaForBusinessAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.alexaforbusiness.auth.AlexaForBusinessIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.alexaforbusiness.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.alexaforbusiness.model.*
import aws.sdk.kotlin.services.alexaforbusiness.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultAlexaForBusinessClient(override val config: AlexaForBusinessClient.Config) : AlexaForBusinessClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = AlexaForBusinessIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "a4b")
        }
        toMap()
    }
    private val authSchemeAdapter = AlexaForBusinessAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.alexaforbusiness"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user implicitly accepts access to this skill during enablement.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun approveSkill(input: ApproveSkillRequest): ApproveSkillResponse {
        val op = SdkHttpOperation.build<ApproveSkillRequest, ApproveSkillResponse> {
            serializer = ApproveSkillOperationSerializer()
            deserializer = ApproveSkillOperationDeserializer()
            operationName = "ApproveSkill"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a contact with a given address book.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateContactWithAddressBook(input: AssociateContactWithAddressBookRequest): AssociateContactWithAddressBookResponse {
        val op = SdkHttpOperation.build<AssociateContactWithAddressBookRequest, AssociateContactWithAddressBookResponse> {
            serializer = AssociateContactWithAddressBookOperationSerializer()
            deserializer = AssociateContactWithAddressBookOperationDeserializer()
            operationName = "AssociateContactWithAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a device with the specified network profile.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateDeviceWithNetworkProfile(input: AssociateDeviceWithNetworkProfileRequest): AssociateDeviceWithNetworkProfileResponse {
        val op = SdkHttpOperation.build<AssociateDeviceWithNetworkProfileRequest, AssociateDeviceWithNetworkProfileResponse> {
            serializer = AssociateDeviceWithNetworkProfileOperationSerializer()
            deserializer = AssociateDeviceWithNetworkProfileOperationDeserializer()
            operationName = "AssociateDeviceWithNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all the skills in any skill groups added to that room. This operation requires the device to be online, or else a manual sync is required.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateDeviceWithRoom(input: AssociateDeviceWithRoomRequest): AssociateDeviceWithRoomResponse {
        val op = SdkHttpOperation.build<AssociateDeviceWithRoomRequest, AssociateDeviceWithRoomResponse> {
            serializer = AssociateDeviceWithRoomOperationSerializer()
            deserializer = AssociateDeviceWithRoomOperationDeserializer()
            operationName = "AssociateDeviceWithRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices in the room.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateSkillGroupWithRoom(input: AssociateSkillGroupWithRoomRequest): AssociateSkillGroupWithRoomResponse {
        val op = SdkHttpOperation.build<AssociateSkillGroupWithRoomRequest, AssociateSkillGroupWithRoomResponse> {
            serializer = AssociateSkillGroupWithRoomOperationSerializer()
            deserializer = AssociateSkillGroupWithRoomOperationDeserializer()
            operationName = "AssociateSkillGroupWithRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a skill with a skill group.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateSkillWithSkillGroup(input: AssociateSkillWithSkillGroupRequest): AssociateSkillWithSkillGroupResponse {
        val op = SdkHttpOperation.build<AssociateSkillWithSkillGroupRequest, AssociateSkillWithSkillGroupResponse> {
            serializer = AssociateSkillWithSkillGroupOperationSerializer()
            deserializer = AssociateSkillWithSkillGroupOperationDeserializer()
            operationName = "AssociateSkillWithSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Makes a private skill available for enrolled users to enable on their devices.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun associateSkillWithUsers(input: AssociateSkillWithUsersRequest): AssociateSkillWithUsersResponse {
        val op = SdkHttpOperation.build<AssociateSkillWithUsersRequest, AssociateSkillWithUsersResponse> {
            serializer = AssociateSkillWithUsersOperationSerializer()
            deserializer = AssociateSkillWithUsersOperationDeserializer()
            operationName = "AssociateSkillWithUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an address book with the specified details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createAddressBook(input: CreateAddressBookRequest): CreateAddressBookResponse {
        val op = SdkHttpOperation.build<CreateAddressBookRequest, CreateAddressBookResponse> {
            serializer = CreateAddressBookOperationSerializer()
            deserializer = CreateAddressBookOperationDeserializer()
            operationName = "CreateAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or weekly interval.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createBusinessReportSchedule(input: CreateBusinessReportScheduleRequest): CreateBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<CreateBusinessReportScheduleRequest, CreateBusinessReportScheduleResponse> {
            serializer = CreateBusinessReportScheduleOperationSerializer()
            deserializer = CreateBusinessReportScheduleOperationDeserializer()
            operationName = "CreateBusinessReportSchedule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new conference provider under the user's AWS account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createConferenceProvider(input: CreateConferenceProviderRequest): CreateConferenceProviderResponse {
        val op = SdkHttpOperation.build<CreateConferenceProviderRequest, CreateConferenceProviderResponse> {
            serializer = CreateConferenceProviderOperationSerializer()
            deserializer = CreateConferenceProviderOperationDeserializer()
            operationName = "CreateConferenceProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a contact with the specified details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createContact(input: CreateContactRequest): CreateContactResponse {
        val op = SdkHttpOperation.build<CreateContactRequest, CreateContactResponse> {
            serializer = CreateContactOperationSerializer()
            deserializer = CreateContactOperationDeserializer()
            operationName = "CreateContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a gateway group with the specified details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createGatewayGroup(input: CreateGatewayGroupRequest): CreateGatewayGroupResponse {
        val op = SdkHttpOperation.build<CreateGatewayGroupRequest, CreateGatewayGroupResponse> {
            serializer = CreateGatewayGroupOperationSerializer()
            deserializer = CreateGatewayGroupOperationDeserializer()
            operationName = "CreateGatewayGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a network profile with the specified details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createNetworkProfile(input: CreateNetworkProfileRequest): CreateNetworkProfileResponse {
        val op = SdkHttpOperation.build<CreateNetworkProfileRequest, CreateNetworkProfileResponse> {
            serializer = CreateNetworkProfileOperationSerializer()
            deserializer = CreateNetworkProfileOperationDeserializer()
            operationName = "CreateNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new room profile with the specified details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse {
        val op = SdkHttpOperation.build<CreateProfileRequest, CreateProfileResponse> {
            serializer = CreateProfileOperationSerializer()
            deserializer = CreateProfileOperationDeserializer()
            operationName = "CreateProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a room with the specified details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createRoom(input: CreateRoomRequest): CreateRoomResponse {
        val op = SdkHttpOperation.build<CreateRoomRequest, CreateRoomResponse> {
            serializer = CreateRoomOperationSerializer()
            deserializer = CreateRoomOperationDeserializer()
            operationName = "CreateRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a skill group with a specified name and description.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createSkillGroup(input: CreateSkillGroupRequest): CreateSkillGroupResponse {
        val op = SdkHttpOperation.build<CreateSkillGroupRequest, CreateSkillGroupResponse> {
            serializer = CreateSkillGroupOperationSerializer()
            deserializer = CreateSkillGroupOperationDeserializer()
            operationName = "CreateSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            operationName = "CreateUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an address book by the address book ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteAddressBook(input: DeleteAddressBookRequest): DeleteAddressBookResponse {
        val op = SdkHttpOperation.build<DeleteAddressBookRequest, DeleteAddressBookResponse> {
            serializer = DeleteAddressBookOperationSerializer()
            deserializer = DeleteAddressBookOperationDeserializer()
            operationName = "DeleteAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteBusinessReportSchedule(input: DeleteBusinessReportScheduleRequest): DeleteBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<DeleteBusinessReportScheduleRequest, DeleteBusinessReportScheduleResponse> {
            serializer = DeleteBusinessReportScheduleOperationSerializer()
            deserializer = DeleteBusinessReportScheduleOperationDeserializer()
            operationName = "DeleteBusinessReportSchedule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a conference provider.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteConferenceProvider(input: DeleteConferenceProviderRequest): DeleteConferenceProviderResponse {
        val op = SdkHttpOperation.build<DeleteConferenceProviderRequest, DeleteConferenceProviderResponse> {
            serializer = DeleteConferenceProviderOperationSerializer()
            deserializer = DeleteConferenceProviderOperationDeserializer()
            operationName = "DeleteConferenceProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a contact by the contact ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteContact(input: DeleteContactRequest): DeleteContactResponse {
        val op = SdkHttpOperation.build<DeleteContactRequest, DeleteContactResponse> {
            serializer = DeleteContactOperationSerializer()
            deserializer = DeleteContactOperationDeserializer()
            operationName = "DeleteContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a device from Alexa For Business.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteDevice(input: DeleteDeviceRequest): DeleteDeviceResponse {
        val op = SdkHttpOperation.build<DeleteDeviceRequest, DeleteDeviceResponse> {
            serializer = DeleteDeviceOperationSerializer()
            deserializer = DeleteDeviceOperationDeserializer()
            operationName = "DeleteDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * When this action is called for a specified shared device, it allows authorized users to delete the device's entire previous history of voice input data and associated response data. This action can be called once every 24 hours for a specific shared device.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteDeviceUsageData(input: DeleteDeviceUsageDataRequest): DeleteDeviceUsageDataResponse {
        val op = SdkHttpOperation.build<DeleteDeviceUsageDataRequest, DeleteDeviceUsageDataResponse> {
            serializer = DeleteDeviceUsageDataOperationSerializer()
            deserializer = DeleteDeviceUsageDataOperationDeserializer()
            operationName = "DeleteDeviceUsageData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a gateway group.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteGatewayGroup(input: DeleteGatewayGroupRequest): DeleteGatewayGroupResponse {
        val op = SdkHttpOperation.build<DeleteGatewayGroupRequest, DeleteGatewayGroupResponse> {
            serializer = DeleteGatewayGroupOperationSerializer()
            deserializer = DeleteGatewayGroupOperationDeserializer()
            operationName = "DeleteGatewayGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a network profile by the network profile ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteNetworkProfile(input: DeleteNetworkProfileRequest): DeleteNetworkProfileResponse {
        val op = SdkHttpOperation.build<DeleteNetworkProfileRequest, DeleteNetworkProfileResponse> {
            serializer = DeleteNetworkProfileOperationSerializer()
            deserializer = DeleteNetworkProfileOperationDeserializer()
            operationName = "DeleteNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a room profile by the profile ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse {
        val op = SdkHttpOperation.build<DeleteProfileRequest, DeleteProfileResponse> {
            serializer = DeleteProfileOperationSerializer()
            deserializer = DeleteProfileOperationDeserializer()
            operationName = "DeleteProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a room by the room ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse {
        val op = SdkHttpOperation.build<DeleteRoomRequest, DeleteRoomResponse> {
            serializer = DeleteRoomOperationSerializer()
            deserializer = DeleteRoomOperationDeserializer()
            operationName = "DeleteRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteRoomSkillParameter(input: DeleteRoomSkillParameterRequest): DeleteRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<DeleteRoomSkillParameterRequest, DeleteRoomSkillParameterResponse> {
            serializer = DeleteRoomSkillParameterOperationSerializer()
            deserializer = DeleteRoomSkillParameterOperationDeserializer()
            operationName = "DeleteRoomSkillParameter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Unlinks a third-party account from a skill.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteSkillAuthorization(input: DeleteSkillAuthorizationRequest): DeleteSkillAuthorizationResponse {
        val op = SdkHttpOperation.build<DeleteSkillAuthorizationRequest, DeleteSkillAuthorizationResponse> {
            serializer = DeleteSkillAuthorizationOperationSerializer()
            deserializer = DeleteSkillAuthorizationOperationDeserializer()
            operationName = "DeleteSkillAuthorization"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a skill group by skill group ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteSkillGroup(input: DeleteSkillGroupRequest): DeleteSkillGroupResponse {
        val op = SdkHttpOperation.build<DeleteSkillGroupRequest, DeleteSkillGroupResponse> {
            serializer = DeleteSkillGroupOperationSerializer()
            deserializer = DeleteSkillGroupOperationDeserializer()
            operationName = "DeleteSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified user by user ARN and enrollment ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            operationName = "DeleteUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a contact from a given address book.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateContactFromAddressBook(input: DisassociateContactFromAddressBookRequest): DisassociateContactFromAddressBookResponse {
        val op = SdkHttpOperation.build<DisassociateContactFromAddressBookRequest, DisassociateContactFromAddressBookResponse> {
            serializer = DisassociateContactFromAddressBookOperationSerializer()
            deserializer = DisassociateContactFromAddressBookOperationDeserializer()
            operationName = "DisassociateContactFromAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is still registered to the account. The device settings and skills are removed from the room.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateDeviceFromRoom(input: DisassociateDeviceFromRoomRequest): DisassociateDeviceFromRoomResponse {
        val op = SdkHttpOperation.build<DisassociateDeviceFromRoomRequest, DisassociateDeviceFromRoomResponse> {
            serializer = DisassociateDeviceFromRoomOperationSerializer()
            deserializer = DisassociateDeviceFromRoomOperationDeserializer()
            operationName = "DisassociateDeviceFromRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill from a skill group.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateSkillFromSkillGroup(input: DisassociateSkillFromSkillGroupRequest): DisassociateSkillFromSkillGroupResponse {
        val op = SdkHttpOperation.build<DisassociateSkillFromSkillGroupRequest, DisassociateSkillFromSkillGroupResponse> {
            serializer = DisassociateSkillFromSkillGroupOperationSerializer()
            deserializer = DisassociateSkillFromSkillGroupOperationDeserializer()
            operationName = "DisassociateSkillFromSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateSkillFromUsers(input: DisassociateSkillFromUsersRequest): DisassociateSkillFromUsersResponse {
        val op = SdkHttpOperation.build<DisassociateSkillFromUsersRequest, DisassociateSkillFromUsersResponse> {
            serializer = DisassociateSkillFromUsersOperationSerializer()
            deserializer = DisassociateSkillFromUsersOperationDeserializer()
            operationName = "DisassociateSkillFromUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in the room.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateSkillGroupFromRoom(input: DisassociateSkillGroupFromRoomRequest): DisassociateSkillGroupFromRoomResponse {
        val op = SdkHttpOperation.build<DisassociateSkillGroupFromRoomRequest, DisassociateSkillGroupFromRoomResponse> {
            serializer = DisassociateSkillGroupFromRoomOperationSerializer()
            deserializer = DisassociateSkillGroupFromRoomOperationDeserializer()
            operationName = "DisassociateSkillGroupFromRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Forgets smart home appliances associated to a room.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun forgetSmartHomeAppliances(input: ForgetSmartHomeAppliancesRequest): ForgetSmartHomeAppliancesResponse {
        val op = SdkHttpOperation.build<ForgetSmartHomeAppliancesRequest, ForgetSmartHomeAppliancesResponse> {
            serializer = ForgetSmartHomeAppliancesOperationSerializer()
            deserializer = ForgetSmartHomeAppliancesOperationDeserializer()
            operationName = "ForgetSmartHomeAppliances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets address the book details by the address book ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getAddressBook(input: GetAddressBookRequest): GetAddressBookResponse {
        val op = SdkHttpOperation.build<GetAddressBookRequest, GetAddressBookResponse> {
            serializer = GetAddressBookOperationSerializer()
            deserializer = GetAddressBookOperationDeserializer()
            operationName = "GetAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the existing conference preferences.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getConferencePreference(input: GetConferencePreferenceRequest): GetConferencePreferenceResponse {
        val op = SdkHttpOperation.build<GetConferencePreferenceRequest, GetConferencePreferenceResponse> {
            serializer = GetConferencePreferenceOperationSerializer()
            deserializer = GetConferencePreferenceOperationDeserializer()
            operationName = "GetConferencePreference"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a specific conference provider.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getConferenceProvider(input: GetConferenceProviderRequest): GetConferenceProviderResponse {
        val op = SdkHttpOperation.build<GetConferenceProviderRequest, GetConferenceProviderResponse> {
            serializer = GetConferenceProviderOperationSerializer()
            deserializer = GetConferenceProviderOperationDeserializer()
            operationName = "GetConferenceProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the contact details by the contact ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getContact(input: GetContactRequest): GetContactResponse {
        val op = SdkHttpOperation.build<GetContactRequest, GetContactResponse> {
            serializer = GetContactOperationSerializer()
            deserializer = GetContactOperationDeserializer()
            operationName = "GetContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a device by device ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse {
        val op = SdkHttpOperation.build<GetDeviceRequest, GetDeviceResponse> {
            serializer = GetDeviceOperationSerializer()
            deserializer = GetDeviceOperationDeserializer()
            operationName = "GetDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of a gateway.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getGateway(input: GetGatewayRequest): GetGatewayResponse {
        val op = SdkHttpOperation.build<GetGatewayRequest, GetGatewayResponse> {
            serializer = GetGatewayOperationSerializer()
            deserializer = GetGatewayOperationDeserializer()
            operationName = "GetGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of a gateway group.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getGatewayGroup(input: GetGatewayGroupRequest): GetGatewayGroupResponse {
        val op = SdkHttpOperation.build<GetGatewayGroupRequest, GetGatewayGroupResponse> {
            serializer = GetGatewayGroupOperationSerializer()
            deserializer = GetGatewayGroupOperationDeserializer()
            operationName = "GetGatewayGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the configured values for the user enrollment invitation email template.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getInvitationConfiguration(input: GetInvitationConfigurationRequest): GetInvitationConfigurationResponse {
        val op = SdkHttpOperation.build<GetInvitationConfigurationRequest, GetInvitationConfigurationResponse> {
            serializer = GetInvitationConfigurationOperationSerializer()
            deserializer = GetInvitationConfigurationOperationDeserializer()
            operationName = "GetInvitationConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the network profile details by the network profile ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getNetworkProfile(input: GetNetworkProfileRequest): GetNetworkProfileResponse {
        val op = SdkHttpOperation.build<GetNetworkProfileRequest, GetNetworkProfileResponse> {
            serializer = GetNetworkProfileOperationSerializer()
            deserializer = GetNetworkProfileOperationDeserializer()
            operationName = "GetNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a room profile by profile ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getProfile(input: GetProfileRequest): GetProfileResponse {
        val op = SdkHttpOperation.build<GetProfileRequest, GetProfileResponse> {
            serializer = GetProfileOperationSerializer()
            deserializer = GetProfileOperationDeserializer()
            operationName = "GetProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets room details by room ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getRoom(input: GetRoomRequest): GetRoomResponse {
        val op = SdkHttpOperation.build<GetRoomRequest, GetRoomResponse> {
            serializer = GetRoomOperationSerializer()
            deserializer = GetRoomOperationDeserializer()
            operationName = "GetRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getRoomSkillParameter(input: GetRoomSkillParameterRequest): GetRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<GetRoomSkillParameterRequest, GetRoomSkillParameterResponse> {
            serializer = GetRoomSkillParameterOperationSerializer()
            deserializer = GetRoomSkillParameterOperationDeserializer()
            operationName = "GetRoomSkillParameter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets skill group details by skill group ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getSkillGroup(input: GetSkillGroupRequest): GetSkillGroupResponse {
        val op = SdkHttpOperation.build<GetSkillGroupRequest, GetSkillGroupResponse> {
            serializer = GetSkillGroupOperationSerializer()
            deserializer = GetSkillGroupOperationDeserializer()
            operationName = "GetSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the details of the schedules that a user configured. A download URL of the report associated with each schedule is returned every time this action is called. A new download URL is returned each time, and is valid for 24 hours.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listBusinessReportSchedules(input: ListBusinessReportSchedulesRequest): ListBusinessReportSchedulesResponse {
        val op = SdkHttpOperation.build<ListBusinessReportSchedulesRequest, ListBusinessReportSchedulesResponse> {
            serializer = ListBusinessReportSchedulesOperationSerializer()
            deserializer = ListBusinessReportSchedulesOperationDeserializer()
            operationName = "ListBusinessReportSchedules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists conference providers under a specific AWS account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listConferenceProviders(input: ListConferenceProvidersRequest): ListConferenceProvidersResponse {
        val op = SdkHttpOperation.build<ListConferenceProvidersRequest, ListConferenceProvidersResponse> {
            serializer = ListConferenceProvidersOperationSerializer()
            deserializer = ListConferenceProvidersOperationDeserializer()
            operationName = "ListConferenceProviders"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the device event history, including device connection status, for up to 30 days.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listDeviceEvents(input: ListDeviceEventsRequest): ListDeviceEventsResponse {
        val op = SdkHttpOperation.build<ListDeviceEventsRequest, ListDeviceEventsResponse> {
            serializer = ListDeviceEventsOperationSerializer()
            deserializer = ListDeviceEventsOperationDeserializer()
            operationName = "ListDeviceEvents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listGatewayGroups(input: ListGatewayGroupsRequest): ListGatewayGroupsResponse {
        val op = SdkHttpOperation.build<ListGatewayGroupsRequest, ListGatewayGroupsResponse> {
            serializer = ListGatewayGroupsOperationSerializer()
            deserializer = ListGatewayGroupsOperationDeserializer()
            operationName = "ListGatewayGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that gateway group ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listGateways(input: ListGatewaysRequest): ListGatewaysResponse {
        val op = SdkHttpOperation.build<ListGatewaysRequest, ListGatewaysResponse> {
            serializer = ListGatewaysOperationSerializer()
            deserializer = ListGatewaysOperationDeserializer()
            operationName = "ListGateways"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all enabled skills in a specific skill group.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listSkills(input: ListSkillsRequest): ListSkillsResponse {
        val op = SdkHttpOperation.build<ListSkillsRequest, ListSkillsResponse> {
            serializer = ListSkillsOperationSerializer()
            deserializer = ListSkillsOperationDeserializer()
            operationName = "ListSkills"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all categories in the Alexa skill store.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listSkillsStoreCategories(input: ListSkillsStoreCategoriesRequest): ListSkillsStoreCategoriesResponse {
        val op = SdkHttpOperation.build<ListSkillsStoreCategoriesRequest, ListSkillsStoreCategoriesResponse> {
            serializer = ListSkillsStoreCategoriesOperationSerializer()
            deserializer = ListSkillsStoreCategoriesOperationDeserializer()
            operationName = "ListSkillsStoreCategories"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all skills in the Alexa skill store by category.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listSkillsStoreSkillsByCategory(input: ListSkillsStoreSkillsByCategoryRequest): ListSkillsStoreSkillsByCategoryResponse {
        val op = SdkHttpOperation.build<ListSkillsStoreSkillsByCategoryRequest, ListSkillsStoreSkillsByCategoryResponse> {
            serializer = ListSkillsStoreSkillsByCategoryOperationSerializer()
            deserializer = ListSkillsStoreSkillsByCategoryOperationDeserializer()
            operationName = "ListSkillsStoreSkillsByCategory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the smart home appliances associated with a room.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listSmartHomeAppliances(input: ListSmartHomeAppliancesRequest): ListSmartHomeAppliancesResponse {
        val op = SdkHttpOperation.build<ListSmartHomeAppliancesRequest, ListSmartHomeAppliancesResponse> {
            serializer = ListSmartHomeAppliancesOperationSerializer()
            deserializer = ListSmartHomeAppliancesOperationDeserializer()
            operationName = "ListSmartHomeAppliances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags for the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            operationName = "ListTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the conference preferences on a specific conference provider at the account level.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun putConferencePreference(input: PutConferencePreferenceRequest): PutConferencePreferenceResponse {
        val op = SdkHttpOperation.build<PutConferencePreferenceRequest, PutConferencePreferenceResponse> {
            serializer = PutConferencePreferenceOperationSerializer()
            deserializer = PutConferencePreferenceOperationDeserializer()
            operationName = "PutConferencePreference"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Configures the email template for the user enrollment invitation with the specified attributes.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun putInvitationConfiguration(input: PutInvitationConfigurationRequest): PutInvitationConfigurationResponse {
        val op = SdkHttpOperation.build<PutInvitationConfigurationRequest, PutInvitationConfigurationResponse> {
            serializer = PutInvitationConfigurationOperationSerializer()
            deserializer = PutInvitationConfigurationOperationDeserializer()
            operationName = "PutInvitationConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill parameter.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun putRoomSkillParameter(input: PutRoomSkillParameterRequest): PutRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<PutRoomSkillParameterRequest, PutRoomSkillParameterResponse> {
            serializer = PutRoomSkillParameterOperationSerializer()
            deserializer = PutRoomSkillParameterOperationDeserializer()
            operationName = "PutRoomSkillParameter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role, the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the IAM role.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun putSkillAuthorization(input: PutSkillAuthorizationRequest): PutSkillAuthorizationResponse {
        val op = SdkHttpOperation.build<PutSkillAuthorizationRequest, PutSkillAuthorizationResponse> {
            serializer = PutSkillAuthorizationOperationSerializer()
            deserializer = PutSkillAuthorizationOperationDeserializer()
            operationName = "PutSkillAuthorization"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service (AVS).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun registerAvsDevice(input: RegisterAvsDeviceRequest): RegisterAvsDeviceResponse {
        val op = SdkHttpOperation.build<RegisterAvsDeviceRequest, RegisterAvsDeviceResponse> {
            serializer = RegisterAVSDeviceOperationSerializer()
            deserializer = RegisterAVSDeviceOperationDeserializer()
            operationName = "RegisterAVSDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the ApproveSkill API.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun rejectSkill(input: RejectSkillRequest): RejectSkillResponse {
        val op = SdkHttpOperation.build<RejectSkillRequest, RejectSkillResponse> {
            serializer = RejectSkillOperationSerializer()
            deserializer = RejectSkillOperationDeserializer()
            operationName = "RejectSkill"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill developers.
     *
     * To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized. When the skill is using an AWS Lambda function, the skill is automatically authorized when you publish your skill as a private skill to your AWS account. Skills that are hosted using a custom web service must be manually authorized. To get your skill authorized, contact AWS Support with your AWS account ID that queries the ResolveRoom API and skill ID.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun resolveRoom(input: ResolveRoomRequest): ResolveRoomResponse {
        val op = SdkHttpOperation.build<ResolveRoomRequest, ResolveRoomResponse> {
            serializer = ResolveRoomOperationSerializer()
            deserializer = ResolveRoomOperationDeserializer()
            operationName = "ResolveRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Revokes an invitation and invalidates the enrollment URL.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun revokeInvitation(input: RevokeInvitationRequest): RevokeInvitationResponse {
        val op = SdkHttpOperation.build<RevokeInvitationRequest, RevokeInvitationResponse> {
            serializer = RevokeInvitationOperationSerializer()
            deserializer = RevokeInvitationOperationDeserializer()
            operationName = "RevokeInvitation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun searchAddressBooks(input: SearchAddressBooksRequest): SearchAddressBooksResponse {
        val op = SdkHttpOperation.build<SearchAddressBooksRequest, SearchAddressBooksResponse> {
            serializer = SearchAddressBooksOperationSerializer()
            deserializer = SearchAddressBooksOperationDeserializer()
            operationName = "SearchAddressBooks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun searchContacts(input: SearchContactsRequest): SearchContactsResponse {
        val op = SdkHttpOperation.build<SearchContactsRequest, SearchContactsResponse> {
            serializer = SearchContactsOperationSerializer()
            deserializer = SearchContactsOperationDeserializer()
            operationName = "SearchContacts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches devices and lists the ones that meet a set of filter criteria.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun searchDevices(input: SearchDevicesRequest): SearchDevicesResponse {
        val op = SdkHttpOperation.build<SearchDevicesRequest, SearchDevicesResponse> {
            serializer = SearchDevicesOperationSerializer()
            deserializer = SearchDevicesOperationDeserializer()
            operationName = "SearchDevices"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun searchNetworkProfiles(input: SearchNetworkProfilesRequest): SearchNetworkProfilesResponse {
        val op = SdkHttpOperation.build<SearchNetworkProfilesRequest, SearchNetworkProfilesResponse> {
            serializer = SearchNetworkProfilesOperationSerializer()
            deserializer = SearchNetworkProfilesOperationDeserializer()
            operationName = "SearchNetworkProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun searchProfiles(input: SearchProfilesRequest): SearchProfilesResponse {
        val op = SdkHttpOperation.build<SearchProfilesRequest, SearchProfilesResponse> {
            serializer = SearchProfilesOperationSerializer()
            deserializer = SearchProfilesOperationDeserializer()
            operationName = "SearchProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun searchRooms(input: SearchRoomsRequest): SearchRoomsResponse {
        val op = SdkHttpOperation.build<SearchRoomsRequest, SearchRoomsResponse> {
            serializer = SearchRoomsOperationSerializer()
            deserializer = SearchRoomsOperationDeserializer()
            operationName = "SearchRooms"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun searchSkillGroups(input: SearchSkillGroupsRequest): SearchSkillGroupsResponse {
        val op = SdkHttpOperation.build<SearchSkillGroupsRequest, SearchSkillGroupsResponse> {
            serializer = SearchSkillGroupsOperationSerializer()
            deserializer = SearchSkillGroupsOperationDeserializer()
            operationName = "SearchSkillGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun searchUsers(input: SearchUsersRequest): SearchUsersResponse {
        val op = SdkHttpOperation.build<SearchUsersRequest, SearchUsersResponse> {
            serializer = SearchUsersOperationSerializer()
            deserializer = SearchUsersOperationDeserializer()
            operationName = "SearchUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search or filter.
     */
    override suspend fun sendAnnouncement(input: SendAnnouncementRequest): SendAnnouncementResponse {
        val op = SdkHttpOperation.build<SendAnnouncementRequest, SendAnnouncementResponse> {
            serializer = SendAnnouncementOperationSerializer()
            deserializer = SendAnnouncementOperationDeserializer()
            operationName = "SendAnnouncement"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this operation again, whichever comes first.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun sendInvitation(input: SendInvitationRequest): SendInvitationResponse {
        val op = SdkHttpOperation.build<SendInvitationRequest, SendInvitationResponse> {
            serializer = SendInvitationOperationSerializer()
            deserializer = SendInvitationOperationDeserializer()
            operationName = "SendInvitation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Resets a device and its account to the known default settings. This clears all information and settings set by previous users in the following ways:
     * + Bluetooth - This unpairs all bluetooth devices paired with your echo device.
     * + Volume - This resets the echo device's volume to the default value.
     * + Notifications - This clears all notifications from your echo device.
     * + Lists - This clears all to-do items from your echo device.
     * + Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address books, delegation access for account linking, and communications (if enabled on the room profile).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun startDeviceSync(input: StartDeviceSyncRequest): StartDeviceSyncResponse {
        val op = SdkHttpOperation.build<StartDeviceSyncRequest, StartDeviceSyncResponse> {
            serializer = StartDeviceSyncOperationSerializer()
            deserializer = StartDeviceSyncOperationDeserializer()
            operationName = "StartDeviceSync"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates the discovery of any smart home appliances associated with the room.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun startSmartHomeApplianceDiscovery(input: StartSmartHomeApplianceDiscoveryRequest): StartSmartHomeApplianceDiscoveryResponse {
        val op = SdkHttpOperation.build<StartSmartHomeApplianceDiscoveryRequest, StartSmartHomeApplianceDiscoveryResponse> {
            serializer = StartSmartHomeApplianceDiscoveryOperationSerializer()
            deserializer = StartSmartHomeApplianceDiscoveryOperationDeserializer()
            operationName = "StartSmartHomeApplianceDiscovery"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds metadata tags to a specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes metadata tags from a specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates address book details by the address book ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateAddressBook(input: UpdateAddressBookRequest): UpdateAddressBookResponse {
        val op = SdkHttpOperation.build<UpdateAddressBookRequest, UpdateAddressBookResponse> {
            serializer = UpdateAddressBookOperationSerializer()
            deserializer = UpdateAddressBookOperationDeserializer()
            operationName = "UpdateAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateBusinessReportSchedule(input: UpdateBusinessReportScheduleRequest): UpdateBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<UpdateBusinessReportScheduleRequest, UpdateBusinessReportScheduleResponse> {
            serializer = UpdateBusinessReportScheduleOperationSerializer()
            deserializer = UpdateBusinessReportScheduleOperationDeserializer()
            operationName = "UpdateBusinessReportSchedule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing conference provider's settings.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateConferenceProvider(input: UpdateConferenceProviderRequest): UpdateConferenceProviderResponse {
        val op = SdkHttpOperation.build<UpdateConferenceProviderRequest, UpdateConferenceProviderResponse> {
            serializer = UpdateConferenceProviderOperationSerializer()
            deserializer = UpdateConferenceProviderOperationDeserializer()
            operationName = "UpdateConferenceProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the contact details by the contact ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse {
        val op = SdkHttpOperation.build<UpdateContactRequest, UpdateContactResponse> {
            serializer = UpdateContactOperationSerializer()
            deserializer = UpdateContactOperationDeserializer()
            operationName = "UpdateContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the device name by device ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateDevice(input: UpdateDeviceRequest): UpdateDeviceResponse {
        val op = SdkHttpOperation.build<UpdateDeviceRequest, UpdateDeviceResponse> {
            serializer = UpdateDeviceOperationSerializer()
            deserializer = UpdateDeviceOperationDeserializer()
            operationName = "UpdateDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left unmodified.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateGateway(input: UpdateGatewayRequest): UpdateGatewayResponse {
        val op = SdkHttpOperation.build<UpdateGatewayRequest, UpdateGatewayResponse> {
            serializer = UpdateGatewayOperationSerializer()
            deserializer = UpdateGatewayOperationDeserializer()
            operationName = "UpdateGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value is left unmodified.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateGatewayGroup(input: UpdateGatewayGroupRequest): UpdateGatewayGroupResponse {
        val op = SdkHttpOperation.build<UpdateGatewayGroupRequest, UpdateGatewayGroupResponse> {
            serializer = UpdateGatewayGroupOperationSerializer()
            deserializer = UpdateGatewayGroupOperationDeserializer()
            operationName = "UpdateGatewayGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a network profile by the network profile ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateNetworkProfile(input: UpdateNetworkProfileRequest): UpdateNetworkProfileResponse {
        val op = SdkHttpOperation.build<UpdateNetworkProfileRequest, UpdateNetworkProfileResponse> {
            serializer = UpdateNetworkProfileOperationSerializer()
            deserializer = UpdateNetworkProfileOperationDeserializer()
            operationName = "UpdateNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing room profile by room profile ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse {
        val op = SdkHttpOperation.build<UpdateProfileRequest, UpdateProfileResponse> {
            serializer = UpdateProfileOperationSerializer()
            deserializer = UpdateProfileOperationDeserializer()
            operationName = "UpdateProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates room details by room ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse {
        val op = SdkHttpOperation.build<UpdateRoomRequest, UpdateRoomResponse> {
            serializer = UpdateRoomOperationSerializer()
            deserializer = UpdateRoomOperationDeserializer()
            operationName = "UpdateRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates skill group details by skill group ARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updateSkillGroup(input: UpdateSkillGroupRequest): UpdateSkillGroupResponse {
        val op = SdkHttpOperation.build<UpdateSkillGroupRequest, UpdateSkillGroupResponse> {
            serializer = UpdateSkillGroupOperationSerializer()
            deserializer = UpdateSkillGroupOperationDeserializer()
            operationName = "UpdateSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "a4b")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
