// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Creates settings for the instant booking feature that are applied to a room profile. When users start their meeting with Alexa, Alexa automatically books the room for the configured duration if the room is available.
 */
public class CreateInstantBooking private constructor(builder: Builder) {
    /**
     * Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room when a meeting is started with Alexa.
     */
    public val durationInMinutes: kotlin.Int = requireNotNull(builder.durationInMinutes) { "A non-null value must be provided for durationInMinutes" }
    /**
     * Whether instant booking is enabled or not.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.alexaforbusiness.model.CreateInstantBooking = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateInstantBooking(")
        append("durationInMinutes=$durationInMinutes,")
        append("enabled=$enabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInMinutes
        result = 31 * result + (enabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateInstantBooking

        if (durationInMinutes != other.durationInMinutes) return false
        if (enabled != other.enabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.alexaforbusiness.model.CreateInstantBooking = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room when a meeting is started with Alexa.
         */
        public var durationInMinutes: kotlin.Int? = null
        /**
         * Whether instant booking is enabled or not.
         */
        public var enabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.alexaforbusiness.model.CreateInstantBooking) : this() {
            this.durationInMinutes = x.durationInMinutes
            this.enabled = x.enabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.alexaforbusiness.model.CreateInstantBooking = CreateInstantBooking(this)

        internal fun correctErrors(): Builder {
            if (durationInMinutes == null) durationInMinutes = 0
            if (enabled == null) enabled = false
            return this
        }
    }
}
